/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.scope.refresh;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessor;
import org.springframework.cloud.context.scope.GenericScope;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource
public class RefreshScope
extends GenericScope
implements ApplicationContextAware,
Ordered {
    private ApplicationContext context;
    private BeanDefinitionRegistry registry;
    private boolean eager = true;
    private int order = 2147483547;

    public RefreshScope() {
        super.setName("refresh");
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setEager(boolean eager) {
        this.eager = eager;
    }

    @Override
    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.registry = registry;
        super.postProcessBeanDefinitionRegistry(registry);
    }

    @EventListener
    public void start(ContextRefreshedEvent event) {
        if (event.getApplicationContext() == this.context && this.eager && this.registry != null) {
            for (String name : this.context.getBeanDefinitionNames()) {
                BeanDefinition definition = this.registry.getBeanDefinition(name);
                if (!this.getName().equals(definition.getScope()) || definition.isLazyInit()) continue;
                this.context.getBean(name).getClass();
            }
        }
    }

    @ManagedOperation(description="Dispose of the current instance of bean name provided and force a refresh on next method execution.")
    public boolean refresh(String name) {
        if (!name.startsWith("scopedTarget.")) {
            name = "scopedTarget." + name;
        }
        if (super.destroy(name)) {
            this.context.publishEvent((ApplicationEvent)new RefreshScopeRefreshedEvent(name));
            return true;
        }
        return false;
    }

    @ManagedOperation(description="Dispose of the current instance of all beans in this scope and force a refresh on next method execution.")
    public void refreshAll() {
        super.destroy();
        if (this.context != null && this.context.getBeanNamesForType(ConfigurationPropertiesBindingPostProcessor.class).length == 1) {
            try {
                ConfigurationPropertiesBindingPostProcessor processor = (ConfigurationPropertiesBindingPostProcessor)this.context.getBean(ConfigurationPropertiesBindingPostProcessor.class);
                processor.setPropertySources((Iterable)((ConfigurableEnvironment)this.context.getEnvironment()).getPropertySources());
                processor.destroy();
                processor.afterPropertiesSet();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.context.publishEvent((ApplicationEvent)new RefreshScopeRefreshedEvent());
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }
}

