/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.converter;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.verifier.config.ContractVerifierConfigProperties;
import org.springframework.cloud.contract.verifier.converter.ConversionContractVerifierException;
import org.springframework.cloud.contract.verifier.converter.StubGenerator;
import org.springframework.cloud.contract.verifier.converter.StubGeneratorProvider;
import org.springframework.cloud.contract.verifier.file.ContractFileScanner;
import org.springframework.cloud.contract.verifier.file.ContractFileScannerBuilder;
import org.springframework.cloud.contract.verifier.file.ContractMetadata;
import org.springframework.cloud.contract.verifier.util.NamesUtil;
import org.springframework.cloud.contract.verifier.wiremock.DslToWireMockClientConverter;
import wiremock.com.google.common.collect.ListMultimap;

public class RecursiveFilesConverter
implements GroovyObject {
    private final StubGeneratorProvider holder;
    private final ContractVerifierConfigProperties props;
    private final File outMappingsDir;
    private static final transient Log log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public RecursiveFilesConverter(ContractVerifierConfigProperties props, StubGeneratorProvider holder) {
        StubGeneratorProvider stubGeneratorProvider;
        File file;
        ContractVerifierConfigProperties contractVerifierConfigProperties;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.props = contractVerifierConfigProperties = props;
        this.outMappingsDir = file = props.getStubsOutputDir();
        StubGeneratorProvider stubGeneratorProvider2 = holder;
        this.holder = stubGeneratorProvider = DefaultTypeTransformation.booleanUnbox((Object)stubGeneratorProvider2) ? stubGeneratorProvider2 : new StubGeneratorProvider();
    }

    public RecursiveFilesConverter(ContractVerifierConfigProperties props, File outMappingsDir, StubGeneratorProvider holder) {
        StubGeneratorProvider stubGeneratorProvider;
        File file;
        ContractVerifierConfigProperties contractVerifierConfigProperties;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.props = contractVerifierConfigProperties = props;
        this.outMappingsDir = file = outMappingsDir;
        StubGeneratorProvider stubGeneratorProvider2 = holder;
        this.holder = stubGeneratorProvider = DefaultTypeTransformation.booleanUnbox((Object)stubGeneratorProvider2) ? stubGeneratorProvider2 : new StubGeneratorProvider();
    }

    public RecursiveFilesConverter(ContractVerifierConfigProperties props) {
        Object[] objectArray = new Object[]{ScriptBytecodeAdapter.createGroovyObjectWrapper((GroovyObject)props, ContractVerifierConfigProperties.class), ScriptBytecodeAdapter.createPojoWrapper(null, StubGeneratorProvider.class)};
        RecursiveFilesConverter recursiveFilesConverter = this;
        switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, RecursiveFilesConverter.class)) {
            case -1524159976: {
                Object[] objectArray2 = objectArray;
                recursiveFilesConverter((ContractVerifierConfigProperties)ScriptBytecodeAdapter.castToType((Object)objectArray[0], ContractVerifierConfigProperties.class), (File)ScriptBytecodeAdapter.castToType((Object)objectArray[1], File.class));
                break;
            }
            case -275759999: {
                Object[] objectArray2 = objectArray;
                recursiveFilesConverter((ContractVerifierConfigProperties)ScriptBytecodeAdapter.castToType((Object)objectArray[0], ContractVerifierConfigProperties.class), (File)ScriptBytecodeAdapter.castToType((Object)objectArray[1], File.class), (StubGeneratorProvider)ScriptBytecodeAdapter.castToType((Object)objectArray[2], StubGeneratorProvider.class));
                break;
            }
            case -165622056: {
                Object[] objectArray2 = objectArray;
                recursiveFilesConverter((ContractVerifierConfigProperties)ScriptBytecodeAdapter.castToType((Object)objectArray[0], ContractVerifierConfigProperties.class), (StubGeneratorProvider)ScriptBytecodeAdapter.castToType((Object)objectArray[1], StubGeneratorProvider.class));
                break;
            }
            case 1460362849: {
                Object[] objectArray2 = objectArray;
                recursiveFilesConverter((ContractVerifierConfigProperties)ScriptBytecodeAdapter.castToType((Object)objectArray[0], ContractVerifierConfigProperties.class));
                break;
            }
            default: {
                throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
            }
        }
    }

    public RecursiveFilesConverter(ContractVerifierConfigProperties props, File outMappingsDir) {
        this(props, outMappingsDir, null);
    }

    public void processFiles() {
        ContractFileScanner scanner = new ContractFileScannerBuilder().baseDir(this.props.getContractsDslDir()).excluded((Set)ScriptBytecodeAdapter.asType((Object)this.props.getExcludedFiles(), Set.class)).ignored((Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class)).included((Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class)).includeMatcher(this.props.getIncludedContracts()).build();
        ListMultimap contracts = scanner.findContracts();
        if (log.isDebugEnabled()) {
            Object v0;
            if (log.isDebugEnabled()) {
                log.debug((Object)new GStringImpl(new Object[]{contracts}, new String[]{"Found the following contracts ", ""}));
                v0 = null;
            } else {
                v0 = null;
            }
        }
        public class _processFiles_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _processFiles_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object entry) {
                Reference entry2 = new Reference(entry);
                public class _closure2
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference entry;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure2(Object _outerInstance, Object _thisObject, Reference entry) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.entry = reference = entry;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public Object doCall(ContractMetadata contract) {
                        contract = new Reference((Object)contract);
                        if (RecursiveFilesConverter.pfaccess$2(null).isDebugEnabled()) {
                            if (RecursiveFilesConverter.pfaccess$2(null).isDebugEnabled()) {
                                RecursiveFilesConverter.pfaccess$2(null).debug((Object)new GStringImpl(new Object[]{(ContractMetadata)contract.get()}, new String[]{"Will create a stub for contract [", "]"}));
                                v0 = null;
                            } else {
                                v0 = null;
                            }
                        }
                        sourceFile = new Reference((Object)((ContractMetadata)contract.get()).getPath().toFile());
                        stubGenerators = DefaultTypeTransformation.booleanUnbox((Object)((ContractMetadata)contract.get()).getConvertedContract()) != false ? RecursiveFilesConverter.pfaccess$0((RecursiveFilesConverter)this.getThisObject()).allOrDefault(new DslToWireMockClientConverter()) : RecursiveFilesConverter.pfaccess$0((RecursiveFilesConverter)this.getThisObject()).converterForName(((File)sourceFile.get()).getName());
                        path = ((File)sourceFile.get()).getPath();
                        if (!(RecursiveFilesConverter.pfaccess$1((RecursiveFilesConverter)this.getThisObject()).isExcludeBuildFolders() != false && (RecursiveFilesConverter.access$0((RecursiveFilesConverter)this.getThisObject(), path, "target") != false || RecursiveFilesConverter.access$0((RecursiveFilesConverter)this.getThisObject(), path, "build") != false) != false)) ** GOTO lbl27
                        if (RecursiveFilesConverter.pfaccess$2(null).isDebugEnabled()) {
                            if (RecursiveFilesConverter.pfaccess$2(null).isDebugEnabled()) {
                                RecursiveFilesConverter.pfaccess$2(null).debug((Object)new GStringImpl(new Object[]{path}, new String[]{"Exclude build folder is set. Path [", "] contains [target] or [build] in its path"}));
                                v1 = null;
                            } else {
                                v1 = null;
                            }
                        }
                        var6_6 = null;
                        return var6_6;
lbl27:
                        // 1 sources

                        if (!(DefaultTypeTransformation.booleanUnbox((Object)((ContractMetadata)contract.get()).getConvertedContract()) == false != false && DefaultTypeTransformation.booleanUnbox(stubGenerators) == false != false)) ** GOTO lbl33
                        var7_7 = null;
                        return var7_7;
lbl33:
                        // 1 sources

                        contractsSize = new Reference((Object)((ContractMetadata)contract.get()).getConvertedContract().size());
                        entryKey = new Reference((Object)((Path)ScriptBytecodeAdapter.castToType(((Map.Entry)this.entry.get()).getKey(), Path.class)));
                        if (RecursiveFilesConverter.pfaccess$2(null).isDebugEnabled()) {
                            if (RecursiveFilesConverter.pfaccess$2(null).isDebugEnabled()) {
                                RecursiveFilesConverter.pfaccess$2(null).debug((Object)new GStringImpl(new Object[]{stubGenerators, (Path)entryKey.get()}, new String[]{"Stub Generators [", "] will convert contents of [", "]"}));
                                v2 = null;
                            } else {
                                v2 = null;
                            }
                        }
                        var10_10 = DefaultGroovyMethods.each(stubGenerators, (Closure)new _processFiles_closure1._closure2._closure3((Object)this, this.getThisObject(), entryKey, contract, sourceFile, contractsSize));
                        try {
                            return var10_10;
                        }
                        catch (Exception e) {
                            throw (Throwable)new ConversionContractVerifierException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((File)sourceFile.get()).getName()}, new String[]{"Unable to make conversion of ", ""})), e);
                        }
                    }

                    public Object call(ContractMetadata contract) {
                        Reference contract2 = new Reference((Object)contract);
                        return this.doCall((ContractMetadata)contract2.get());
                    }

                    public Object getEntry() {
                        return this.entry.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return DefaultGroovyMethods.each((Collection)((Collection)ScriptBytecodeAdapter.castToType(((Map.Entry)entry2.get()).getValue(), Collection.class)), (Closure)new _closure2((Object)this, this.getThisObject(), entry2));
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processFiles_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(contracts.asMap().entrySet(), (Closure)new _processFiles_closure1(this, this));
    }

    private boolean matchesPath(String path, String folder) {
        return path.matches(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{File.separator, folder, File.separator}, new String[]{"^.*", "", "", ".*$"})));
    }

    private Path createAndReturnTargetDirectory(File sourceFile) {
        Path relativePath = Paths.get(this.props.getContractsDslDir().toURI()).relativize(sourceFile.getParentFile().toPath());
        Path absoluteTargetPath = this.outMappingsDir.toPath().resolve(relativePath);
        Files.createDirectories(absoluteTargetPath, new FileAttribute[0]);
        return absoluteTargetPath;
    }

    private File createTargetFileWithProperName(StubGenerator stubGenerator, Path absoluteTargetPath, File sourceFile, int contractsSize, int index, Contract dsl) {
        Object v0;
        String name = this.generateName(dsl, contractsSize, stubGenerator, sourceFile, index);
        File newJsonFile = new File(absoluteTargetPath.toFile(), name);
        if (log.isInfoEnabled()) {
            log.info((Object)new GStringImpl(new Object[]{newJsonFile.getPath()}, new String[]{"Creating new stub [", "]"}));
            v0 = null;
        } else {
            v0 = null;
        }
        return newJsonFile;
    }

    private String generateName(Contract dsl, int contractsSize, StubGenerator converter, File sourceFile, int index) {
        String generatedName = converter.generateOutputFileNameForInput(sourceFile.getName());
        boolean hasDot = NamesUtil.hasDot((String)generatedName);
        String extension = hasDot ? NamesUtil.afterLastDot((String)generatedName) : "";
        if (DefaultTypeTransformation.booleanUnbox((Object)dsl.getName()) && DefaultTypeTransformation.booleanUnbox((Object)extension)) {
            return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{dsl.getName(), extension}, new String[]{"", ".", ""}));
        }
        if (contractsSize == 1) {
            return generatedName;
        }
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{index, generatedName}, new String[]{"", "_", ""}));
    }

    public static /* synthetic */ boolean access$0(RecursiveFilesConverter $that, String path, String folder) {
        return $that.matchesPath(path, folder);
    }

    public static /* synthetic */ StubGeneratorProvider pfaccess$0(RecursiveFilesConverter $that) {
        return $that.holder;
    }

    public static /* synthetic */ ContractVerifierConfigProperties pfaccess$1(RecursiveFilesConverter $that) {
        return $that.props;
    }

    public static /* synthetic */ Log pfaccess$2(RecursiveFilesConverter $that) {
        return log;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RecursiveFilesConverter.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Log log;
        RecursiveFilesConverter.log = log = LogFactory.getLog((String)"org.springframework.cloud.contract.verifier.converter.RecursiveFilesConverter");
    }
}

