/*******************************************************************************
 * Copyright (c) 2013 Sonatype, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Sonatype, Inc. - initial API and implementation
 *******************************************************************************/
package shaded.shaded.org.eclipse.aether.connector.basic;

import org.eclipse.aether.repository.RemoteRepository;
import shaded.shaded.org.eclipse.aether.spi.connector.MetadataTransfer;
import shaded.shaded.org.eclipse.aether.spi.connector.transport.Transporter;
import org.eclipse.aether.transfer.MetadataNotFoundException;
import org.eclipse.aether.transfer.MetadataTransferException;
import org.eclipse.aether.transfer.TransferEvent;

final class MetadataTransportListener
    extends TransferTransportListener<MetadataTransfer>
{

    private final RemoteRepository repository;

    public MetadataTransportListener( MetadataTransfer transfer, RemoteRepository repository,
                                      TransferEvent.Builder eventBuilder )
    {
        super( transfer, eventBuilder );
        this.repository = repository;
    }

    @Override
    public void transferFailed( Exception exception, int classification )
    {
        MetadataTransferException e;
        if ( classification == Transporter.ERROR_NOT_FOUND )
        {
            e = new MetadataNotFoundException( getTransfer().getMetadata(), repository );
        }
        else
        {
            e = new MetadataTransferException( getTransfer().getMetadata(), repository, exception );
        }
        getTransfer().setException( e );
        super.transferFailed( e, classification );
    }

}
