/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.spec.internal.BodyMatchers;
import org.springframework.cloud.contract.spec.internal.ClientDslProperty;
import org.springframework.cloud.contract.spec.internal.Common;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.ExecutionProperty;
import org.springframework.cloud.contract.spec.internal.Headers;
import org.springframework.cloud.contract.spec.internal.PatternValueDslProperty;
import org.springframework.cloud.contract.spec.internal.RegexCreatingProperty;
import org.springframework.cloud.contract.spec.internal.RegexProperty;

public class Input
extends Common
implements RegexCreatingProperty<ClientDslProperty> {
    private static final Log log = LogFactory.getLog(Input.class);
    private ClientPatternValueDslProperty property = new ClientPatternValueDslProperty();
    private DslProperty<String> messageFrom;
    private ExecutionProperty triggeredBy;
    private Headers messageHeaders = new Headers();
    private BodyType messageBody;
    private ExecutionProperty assertThat;
    private BodyMatchers bodyMatchers;

    public Input() {
    }

    public Input(Input input) {
        this.messageFrom = input.getMessageFrom();
        this.messageHeaders = input.getMessageHeaders();
        this.messageBody = input.getMessageBody();
    }

    public void messageFrom(String messageFrom) {
        this.messageFrom = new DslProperty<String>(messageFrom);
    }

    public void messageFrom(DslProperty messageFrom) {
        this.messageFrom = messageFrom;
    }

    public void triggeredBy(String triggeredBy) {
        this.triggeredBy = new ExecutionProperty(triggeredBy);
    }

    public BodyType messageBody(Object bodyAsValue) {
        this.messageBody = new BodyType(bodyAsValue);
        return this.messageBody;
    }

    public DslProperty value(ClientDslProperty client) {
        Object dynamicValue = client.getClientValue();
        Object concreteValue = client.getServerValue();
        if (dynamicValue instanceof RegexProperty) {
            return ((RegexProperty)dynamicValue).dynamicClientConcreteProducer();
        }
        return new DslProperty(dynamicValue, concreteValue);
    }

    public DslProperty value(RegexProperty prop) {
        return this.value(this.client(prop));
    }

    public DslProperty $(RegexProperty prop) {
        return this.value(this.client(prop));
    }

    public DslProperty $(ClientDslProperty client) {
        return this.value(client);
    }

    @Override
    public RegexProperty regexProperty(Object object) {
        return new RegexProperty(object).dynamicClientConcreteProducer();
    }

    public void assertThat(String assertThat) {
        this.assertThat = new ExecutionProperty(assertThat);
    }

    public ClientPatternValueDslProperty getProperty() {
        return this.property;
    }

    public void setProperty(ClientPatternValueDslProperty property) {
        this.property = property;
    }

    public DslProperty<String> getMessageFrom() {
        return this.messageFrom;
    }

    public void setMessageFrom(DslProperty<String> messageFrom) {
        this.messageFrom = messageFrom;
    }

    public ExecutionProperty getTriggeredBy() {
        return this.triggeredBy;
    }

    public void setTriggeredBy(ExecutionProperty triggeredBy) {
        this.triggeredBy = triggeredBy;
    }

    public Headers getMessageHeaders() {
        return this.messageHeaders;
    }

    public void setMessageHeaders(Headers messageHeaders) {
        this.messageHeaders = messageHeaders;
    }

    public BodyType getMessageBody() {
        return this.messageBody;
    }

    public void setMessageBody(BodyType messageBody) {
        this.messageBody = messageBody;
    }

    public ExecutionProperty getAssertThat() {
        return this.assertThat;
    }

    public void setAssertThat(ExecutionProperty assertThat) {
        this.assertThat = assertThat;
    }

    public BodyMatchers getBodyMatchers() {
        return this.bodyMatchers;
    }

    public void setBodyMatchers(BodyMatchers bodyMatchers) {
        this.bodyMatchers = bodyMatchers;
    }

    @Override
    public ClientDslProperty anyAlphaUnicode() {
        return (ClientDslProperty)this.property.anyAlphaUnicode();
    }

    @Override
    public ClientDslProperty anyAlphaNumeric() {
        return (ClientDslProperty)this.property.anyAlphaNumeric();
    }

    @Override
    public ClientDslProperty anyNumber() {
        return (ClientDslProperty)this.property.anyNumber();
    }

    @Override
    public ClientDslProperty anyInteger() {
        return (ClientDslProperty)this.property.anyInteger();
    }

    @Override
    public ClientDslProperty anyPositiveInt() {
        return (ClientDslProperty)this.property.anyPositiveInt();
    }

    @Override
    public ClientDslProperty anyDouble() {
        return (ClientDslProperty)this.property.anyDouble();
    }

    @Override
    public ClientDslProperty anyHex() {
        return (ClientDslProperty)this.property.anyHex();
    }

    @Override
    public ClientDslProperty aBoolean() {
        return (ClientDslProperty)this.property.aBoolean();
    }

    @Override
    public ClientDslProperty anyIpAddress() {
        return (ClientDslProperty)this.property.anyIpAddress();
    }

    @Override
    public ClientDslProperty anyHostname() {
        return (ClientDslProperty)this.property.anyHostname();
    }

    @Override
    public ClientDslProperty anyEmail() {
        return (ClientDslProperty)this.property.anyEmail();
    }

    @Override
    public ClientDslProperty anyUrl() {
        return (ClientDslProperty)this.property.anyUrl();
    }

    @Override
    public ClientDslProperty anyHttpsUrl() {
        return (ClientDslProperty)this.property.anyHttpsUrl();
    }

    @Override
    public ClientDslProperty anyUuid() {
        return (ClientDslProperty)this.property.anyUuid();
    }

    @Override
    public ClientDslProperty anyDate() {
        return (ClientDslProperty)this.property.anyDate();
    }

    @Override
    public ClientDslProperty anyDateTime() {
        return (ClientDslProperty)this.property.anyDateTime();
    }

    @Override
    public ClientDslProperty anyTime() {
        return (ClientDslProperty)this.property.anyTime();
    }

    @Override
    public ClientDslProperty anyIso8601WithOffset() {
        return (ClientDslProperty)this.property.anyIso8601WithOffset();
    }

    @Override
    public ClientDslProperty anyNonBlankString() {
        return (ClientDslProperty)this.property.anyNonBlankString();
    }

    @Override
    public ClientDslProperty anyNonEmptyString() {
        return (ClientDslProperty)this.property.anyNonEmptyString();
    }

    @Override
    public ClientDslProperty anyOf(String ... values) {
        return (ClientDslProperty)this.property.anyOf(values);
    }

    public void messageHeaders(Consumer<Headers> consumer) {
        this.messageHeaders = new Headers();
        consumer.accept(this.messageHeaders);
    }

    @Deprecated
    public void stubMatchers(Consumer<BodyMatchers> consumer) {
        log.warn((Object)"stubMatchers method is deprecated. Please use bodyMatchers instead");
        this.bodyMatchers(consumer);
    }

    public void bodyMatchers(Consumer<BodyMatchers> consumer) {
        this.bodyMatchers = new BodyMatchers();
        consumer.accept(this.bodyMatchers);
    }

    public void messageHeaders(@DelegatesTo(value=Headers.class) Closure consumer) {
        this.messageHeaders = new Headers();
        consumer.setDelegate((Object)this.messageHeaders);
        consumer.call();
    }

    @Deprecated
    public void stubMatchers(@DelegatesTo(value=BodyMatchers.class) Closure consumer) {
        log.warn((Object)"stubMatchers method is deprecated. Please use bodyMatchers instead");
        this.bodyMatchers(consumer);
    }

    public void bodyMatchers(@DelegatesTo(value=BodyMatchers.class) Closure consumer) {
        this.bodyMatchers = new BodyMatchers();
        consumer.setDelegate((Object)this.bodyMatchers);
        consumer.call();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Input input = (Input)o;
        return Objects.equals(this.messageFrom, input.messageFrom) && Objects.equals(this.triggeredBy, input.triggeredBy) && Objects.equals(this.messageHeaders, input.messageHeaders) && Objects.equals(this.messageBody, input.messageBody) && Objects.equals(this.assertThat, input.assertThat) && Objects.equals(this.bodyMatchers, input.bodyMatchers);
    }

    public int hashCode() {
        return Objects.hash(this.messageFrom, this.triggeredBy, this.messageHeaders, this.messageBody, this.assertThat, this.bodyMatchers);
    }

    public String toString() {
        return "Input{\n\tmessageFrom=" + this.messageFrom + ", \n\ttriggeredBy=" + this.triggeredBy + ", \n\tmessageHeaders=" + this.messageHeaders + ", \n\tmessageBody=" + this.messageBody + ", \n\tassertThat=" + this.assertThat + ", \n\tbodyMatchers=" + this.bodyMatchers + "} \n\t" + super.toString();
    }

    private class ClientPatternValueDslProperty
    extends PatternValueDslProperty<ClientDslProperty> {
        private ClientPatternValueDslProperty() {
        }

        @Override
        protected ClientDslProperty createProperty(Pattern pattern, Object generatedValue) {
            return new ClientDslProperty(pattern, generatedValue);
        }
    }

    public static class BodyType
    extends DslProperty {
        public BodyType(Object clientValue, Object serverValue) {
            super(clientValue, serverValue);
        }

        public BodyType(Object singleValue) {
            super(singleValue);
        }
    }
}

