/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.cloud.contract.spec.internal.CanBeDynamic;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import repackaged.nl.flotsam.xeger.Xeger;

public class RegexProperty
extends DslProperty
implements CanBeDynamic {
    final Pattern pattern;
    private final Class clazz;

    public RegexProperty(Object value) {
        this(value, value, null);
    }

    public RegexProperty(Object client, Object server) {
        this(client, server, null);
    }

    public RegexProperty(Object client, Object server, Class clazz) {
        super(client, server);
        Object dynamicValue;
        boolean serverDynamic;
        boolean clientDynamic = client instanceof Pattern || client instanceof RegexProperty;
        boolean bl = serverDynamic = server instanceof Pattern || server instanceof RegexProperty;
        if (!clientDynamic && !serverDynamic) {
            throw new IllegalStateException("Neither client not server side is dynamic");
        }
        Object object = dynamicValue = clientDynamic ? client : server;
        if (dynamicValue instanceof Pattern) {
            this.pattern = (Pattern)dynamicValue;
            this.clazz = clazz != null ? clazz : String.class;
        } else if (dynamicValue instanceof RegexProperty) {
            RegexProperty regexProperty = (RegexProperty)dynamicValue;
            this.pattern = regexProperty.pattern;
            this.clazz = clazz != null ? clazz : regexProperty.clazz;
        } else {
            this.clazz = clazz;
            this.pattern = null;
        }
    }

    public Matcher matcher(CharSequence input) {
        return this.pattern.matcher(input);
    }

    public String pattern() {
        return this.pattern.pattern();
    }

    public Class clazz() {
        return this.getClass();
    }

    public RegexProperty asInteger() {
        return new RegexProperty(this.getClientValue(), this.getServerValue(), Integer.class);
    }

    public RegexProperty asDouble() {
        return new RegexProperty(this.getClientValue(), this.getServerValue(), Double.class);
    }

    public RegexProperty asFloat() {
        return new RegexProperty(this.getClientValue(), this.getServerValue(), Float.class);
    }

    public RegexProperty asLong() {
        return new RegexProperty(this.getClientValue(), this.getServerValue(), Long.class);
    }

    public RegexProperty asShort() {
        return new RegexProperty(this.getClientValue(), this.getServerValue(), Short.class);
    }

    public RegexProperty asString() {
        return new RegexProperty(this.getClientValue(), this.getServerValue(), String.class);
    }

    public RegexProperty asBooleanType() {
        return new RegexProperty(this.getClientValue(), this.getServerValue(), Boolean.class);
    }

    public Object generate() {
        return this.doGenerate(3);
    }

    private Object doGenerate(int retries) {
        try {
            String generatedValue = new Xeger(this.pattern.pattern()).generate();
            if (Integer.class.equals((Object)this.clazz)) {
                return Integer.parseInt(generatedValue);
            }
            if (Double.class.equals((Object)this.clazz)) {
                return Double.parseDouble(generatedValue);
            }
            if (Float.class.equals((Object)this.clazz)) {
                return Float.valueOf(Float.parseFloat(generatedValue));
            }
            if (Long.class.equals((Object)this.clazz)) {
                return Long.parseLong(generatedValue);
            }
            if (Short.class.equals((Object)this.clazz)) {
                return Short.parseShort(generatedValue);
            }
            if (Boolean.class.equals((Object)this.clazz)) {
                return Boolean.parseBoolean(generatedValue);
            }
            return generatedValue;
        }
        catch (NumberFormatException ex) {
            if (retries > 0) {
                return this.doGenerate(--retries);
            }
            throw ex;
        }
    }

    public Object generateAndEscapeJavaStringIfNeeded() {
        Object generated = this.generate();
        if (this.isNumber()) {
            return generated;
        }
        return StringEscapeUtils.escapeJava((String)String.valueOf(generated));
    }

    private boolean isNumber() {
        return Number.class.isAssignableFrom(this.clazz);
    }

    public RegexProperty dynamicClientConcreteProducer() {
        return new RegexProperty(this.pattern, this.generate(), this.clazz);
    }

    public RegexProperty concreteClientDynamicProducer() {
        return new RegexProperty(this.generate(), this.pattern, this.clazz);
    }

    public RegexProperty concreteClientEscapedDynamicProducer() {
        return new RegexProperty(this.generateAndEscapeJavaStringIfNeeded(), this.pattern, this.clazz);
    }

    public RegexProperty dynamicClientEscapedConcreteProducer() {
        return new RegexProperty(this.pattern, this.generateAndEscapeJavaStringIfNeeded(), this.clazz);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegexProperty that = (RegexProperty)o;
        return Objects.equals(this.stringPatternIfPresent(this.pattern), this.stringPatternIfPresent(that.pattern)) && Objects.equals(this.clazz, that.clazz);
    }

    private Object stringPatternIfPresent(Pattern value) {
        return value != null ? value.pattern() : null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.stringPatternIfPresent(this.pattern), this.clazz);
    }

    @Override
    public String toString() {
        return this.pattern();
    }

    @Override
    public Object generateConcreteValue() {
        return this.generate();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Class getClazz() {
        return this.clazz;
    }
}

