/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.util.Objects;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.JSONCompareMode;

public class MatchingStrategy
extends DslProperty {
    private Type type;
    private JSONCompareMode jsonCompareMode;

    public MatchingStrategy(Object value, Type type) {
        this(value, type, null);
    }

    public MatchingStrategy(Object value, Type type, JSONCompareMode jsonCompareMode) {
        super(value);
        this.type = type;
        this.jsonCompareMode = jsonCompareMode;
    }

    public MatchingStrategy(DslProperty value, Type type) {
        this(value, type, null);
    }

    public MatchingStrategy(DslProperty value, Type type, JSONCompareMode jsonCompareMode) {
        super(value.getClientValue(), value.getServerValue());
        this.type = type;
        this.jsonCompareMode = jsonCompareMode;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public JSONCompareMode getJsonCompareMode() {
        return this.jsonCompareMode;
    }

    public void setJsonCompareMode(JSONCompareMode jsonCompareMode) {
        this.jsonCompareMode = jsonCompareMode;
    }

    @Override
    public String toString() {
        return "MatchingStrategy{type=" + this.type + ", jsonCompareMode=" + this.jsonCompareMode + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MatchingStrategy that = (MatchingStrategy)o;
        return this.type == that.type && this.jsonCompareMode == that.jsonCompareMode;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.type, this.jsonCompareMode});
    }

    public static enum Type {
        EQUAL_TO("equalTo"),
        CONTAINS("containing"),
        MATCHING("matching"),
        NOT_MATCHING("notMatching"),
        EQUAL_TO_JSON("equalToJson"),
        EQUAL_TO_XML("equalToXml"),
        ABSENT("absent"),
        BINARY_EQUAL_TO("binaryEqualTo");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public final String getName() {
            return this.name;
        }
    }
}

