/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.resolution.VersionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.contract.stubrunner.AetherFactories;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.util.ZipCategory;
import org.springframework.util.StringUtils;

public class AetherStubDownloader
implements StubDownloader {
    private static final Logger log = LoggerFactory.getLogger(AetherStubDownloader.class);
    private static final String TEMP_DIR_PREFIX = "contracts";
    private static final String ARTIFACT_EXTENSION = "jar";
    private static final String LATEST_ARTIFACT_VERSION = "(,]";
    private static final String LATEST_VERSION_IN_IVY = "+";
    private final List<RemoteRepository> remoteRepos;
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession session;

    public AetherStubDownloader(StubRunnerOptions stubRunnerOptions) {
        if (log.isDebugEnabled()) {
            log.debug("Will be resolving versions for the following options: [" + stubRunnerOptions + "]");
        }
        this.remoteRepos = this.remoteRepositories(stubRunnerOptions);
        boolean remoteReposMissing = this.remoteReposMissing();
        if (remoteReposMissing && stubRunnerOptions.workOffline) {
            log.info("Remote repos not passed but the switch to work offline was set. Stubs will be used from your local Maven repository.");
        }
        if (remoteReposMissing && !stubRunnerOptions.workOffline) {
            throw new IllegalStateException("Remote repositories for stubs are not specified and work offline flag wasn't passed");
        }
        if (!remoteReposMissing && stubRunnerOptions.workOffline) {
            throw new IllegalStateException("Remote repositories for stubs are specified and work offline flag is set. You have to provide one of them.");
        }
        this.repositorySystem = AetherFactories.newRepositorySystem();
        this.session = AetherFactories.newSession(this.repositorySystem, stubRunnerOptions.workOffline);
    }

    private boolean remoteReposMissing() {
        return this.remoteRepos == null || this.remoteRepos.isEmpty();
    }

    public AetherStubDownloader(RepositorySystem repositorySystem, List<RemoteRepository> remoteRepositories, RepositorySystemSession session) {
        this.remoteRepos = remoteRepositories;
        this.repositorySystem = repositorySystem;
        this.session = session;
        if (this.remoteReposMissing()) {
            log.error("Remote repositories for stubs are not specified and work offline flag wasn't passed");
        }
    }

    private List<RemoteRepository> remoteRepositories(StubRunnerOptions stubRunnerOptions) {
        List<RemoteRepository> remoteRepos = AetherFactories.newRepositories(Arrays.asList(stubRunnerOptions.stubRepositoryRoot.split(",")));
        if (log.isDebugEnabled()) {
            log.debug("Using the following remote repos " + remoteRepos);
        }
        return remoteRepos;
    }

    private File unpackedJar(String resolvedVersion, String stubsGroup, String stubsModule, String classifier) {
        log.info("Resolved version is [" + resolvedVersion + "]");
        if (!StringUtils.hasText((String)resolvedVersion)) {
            log.warn("Stub for group [" + stubsGroup + "] module [" + stubsModule + "] and classifier [" + classifier + "] not found in " + this.remoteRepos);
            return null;
        }
        DefaultArtifact artifact = new DefaultArtifact(stubsGroup, stubsModule, classifier, ARTIFACT_EXTENSION, resolvedVersion);
        ArtifactRequest request = new ArtifactRequest((Artifact)artifact, this.remoteRepos, null);
        log.info("Resolving artifact [" + artifact + "] using remote repositories " + this.remoteRepos);
        try {
            ArtifactResult result = this.repositorySystem.resolveArtifact(this.session, request);
            log.info("Resolved artifact [" + artifact + "] to " + result.getArtifact().getFile());
            File temporaryFile = AetherStubDownloader.unpackStubJarToATemporaryFolder(result.getArtifact().getFile().toURI());
            log.info("Unpacked file to [" + temporaryFile + "]");
            return temporaryFile;
        }
        catch (Exception e) {
            log.warn("Exception occurred while trying to download a stub for group [" + stubsGroup + "] module [" + stubsModule + "] and classifier [" + classifier + "] in " + this.remoteRepos, (Throwable)e);
            return null;
        }
    }

    private String getVersion(String stubsGroup, String stubsModule, String version, String classifier) {
        if (!StringUtils.hasText((String)version) || LATEST_VERSION_IN_IVY.equals(version)) {
            log.info("Desired version is [" + version + "] - will try to resolve the latest version");
            return this.resolveHighestArtifactVersion(stubsGroup, stubsModule, classifier);
        }
        log.info("Will try to resolve version " + version);
        return this.resolveArtifactVersion(stubsGroup, stubsModule, version, classifier);
    }

    @Override
    public Map.Entry<StubConfiguration, File> downloadAndUnpackStubJar(StubRunnerOptions options, StubConfiguration stubConfiguration) {
        File unpackedJar;
        String version = this.getVersion(stubConfiguration.groupId, stubConfiguration.artifactId, stubConfiguration.version, stubConfiguration.classifier);
        if (log.isDebugEnabled()) {
            log.debug("Will download the stub for version [" + version + "]");
        }
        if ((unpackedJar = this.unpackedJar(version, stubConfiguration.groupId, stubConfiguration.artifactId, stubConfiguration.classifier)) == null) {
            return null;
        }
        return new AbstractMap.SimpleEntry<StubConfiguration, File>(new StubConfiguration(stubConfiguration.groupId, stubConfiguration.artifactId, version, stubConfiguration.classifier), unpackedJar);
    }

    private String resolveHighestArtifactVersion(String stubsGroup, String stubsModule, String classifier) {
        VersionRangeResult rangeResult;
        DefaultArtifact artifact = new DefaultArtifact(stubsGroup, stubsModule, classifier, ARTIFACT_EXTENSION, LATEST_ARTIFACT_VERSION);
        VersionRangeRequest versionRangeRequest = new VersionRangeRequest((Artifact)artifact, this.remoteRepos, null);
        try {
            rangeResult = this.repositorySystem.resolveVersionRange(this.session, versionRangeRequest);
            if (log.isDebugEnabled()) {
                log.debug("Resolved version range is [" + rangeResult + "]");
            }
        }
        catch (VersionRangeResolutionException e) {
            throw new IllegalStateException("Cannot resolve version range", e);
        }
        if (rangeResult.getHighestVersion() == null) {
            log.error("For groupId [" + stubsGroup + "] artifactId [" + stubsModule + "] " + "and classifier [" + classifier + "] the version was not resolved!");
        }
        return rangeResult.getHighestVersion() == null ? null : rangeResult.getHighestVersion().toString();
    }

    private String resolveArtifactVersion(String stubsGroup, String stubsModule, String version, String classifier) {
        VersionResult versionResult;
        DefaultArtifact artifact = new DefaultArtifact(stubsGroup, stubsModule, classifier, ARTIFACT_EXTENSION, version);
        VersionRequest versionRequest = new VersionRequest((Artifact)artifact, this.remoteRepos, null);
        try {
            versionResult = this.repositorySystem.resolveVersion(this.session, versionRequest);
        }
        catch (VersionResolutionException e) {
            throw new IllegalStateException("Cannot resolve version", e);
        }
        return versionResult.getVersion() == null ? null : versionResult.getVersion();
    }

    private static File unpackStubJarToATemporaryFolder(URI stubJarUri) {
        File tmpDirWhereStubsWillBeUnzipped;
        try {
            tmpDirWhereStubsWillBeUnzipped = Files.createTempDirectory(TEMP_DIR_PREFIX, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create tmp dir with prefix: [contracts]", e);
        }
        tmpDirWhereStubsWillBeUnzipped.deleteOnExit();
        log.info("Unpacking stub from JAR [URI: " + stubJarUri + "]");
        ZipCategory.unzipTo(new File(stubJarUri), tmpDirWhereStubsWillBeUnzipped);
        return tmpDirWhereStubsWillBeUnzipped;
    }
}

