/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.verifier.config.ContractVerifierConfigProperties;
import org.springframework.util.StringUtils;

public class ContractDownloader {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final StubDownloader stubDownloader;
    private final StubConfiguration contractsJarStubConfiguration;
    private final String contractsPath;
    private final String projectGroupId;
    private final String projectArtifactId;

    public ContractDownloader(StubDownloader stubDownloader, StubConfiguration contractsJarStubConfiguration, String contractsPath, String projectGroupId, String projectArtifactId) {
        this.stubDownloader = stubDownloader;
        this.contractsJarStubConfiguration = contractsJarStubConfiguration;
        this.contractsPath = contractsPath;
        this.projectGroupId = projectGroupId;
        this.projectArtifactId = projectArtifactId;
    }

    public File unpackedDownloadedContracts(ContractVerifierConfigProperties config) {
        File contractsDirectory = this.unpackAndDownloadContracts();
        this.updatePropertiesWithInclusion(contractsDirectory, config);
        return contractsDirectory;
    }

    public ContractVerifierConfigProperties updatePropertiesWithInclusion(File contractsDirectory, ContractVerifierConfigProperties config) {
        String pattern = StringUtils.hasText((String)this.contractsPath) ? this.patternFromProperty(contractsDirectory) : this.groupArtifactToPattern(contractsDirectory);
        log.info((Object)("Pattern to pick contracts equals [" + pattern + "]"));
        config.setIncludedContracts(pattern);
        return config;
    }

    private String patternFromProperty(File contractsDirectory) {
        return "^" + contractsDirectory.getAbsolutePath() + this.contractsPath() + ".*$";
    }

    private String contractsPath() {
        return this.contractsPath.startsWith(File.separator) ? this.contractsPath : File.separator + this.contractsPath;
    }

    private File unpackAndDownloadContracts() {
        log.info((Object)("Will download contracts for [" + this.contractsJarStubConfiguration + "]"));
        Map.Entry<StubConfiguration, File> unpackedContractStubs = this.stubDownloader.downloadAndUnpackStubJar(null, this.contractsJarStubConfiguration);
        if (unpackedContractStubs == null) {
            throw new IllegalStateException("The contracts failed to be downloaded!");
        }
        return unpackedContractStubs.getValue();
    }

    private String groupArtifactToPattern(File contractsDirectory) {
        return "^" + contractsDirectory.getAbsolutePath() + File.separator + this.projectGroupId.replace(".", File.separator) + File.separator + this.projectArtifactId + File.separator + ".*$";
    }
}

