/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import groovy.json.JsonOutput;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.Headers;
import org.springframework.cloud.contract.spec.internal.OutputMessage;
import org.springframework.cloud.contract.stubrunner.AvailablePortScanner;
import org.springframework.cloud.contract.stubrunner.NoOpHttpServerStub;
import org.springframework.cloud.contract.stubrunner.RunningStubs;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubFinder;
import org.springframework.cloud.contract.stubrunner.StubRepository;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.StubServer;
import org.springframework.cloud.contract.stubrunner.WireMockHttpServerStub;
import org.springframework.cloud.contract.stubrunner.WiremockMappingDescriptor;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.noop.NoOpStubMessages;
import org.springframework.cloud.contract.verifier.util.BodyExtractor;

class StubRunnerExecutor
implements StubFinder {
    private static final Logger log = LoggerFactory.getLogger(StubRunnerExecutor.class);
    private final AvailablePortScanner portScanner;
    private final MessageVerifier<?> contractVerifierMessaging;
    private StubServer stubServer;

    public StubRunnerExecutor(AvailablePortScanner portScanner, MessageVerifier<?> contractVerifierMessaging) {
        this.portScanner = portScanner;
        this.contractVerifierMessaging = contractVerifierMessaging;
    }

    protected StubRunnerExecutor(AvailablePortScanner portScanner) {
        this(portScanner, (MessageVerifier<?>)new NoOpStubMessages());
    }

    public RunningStubs runStubs(StubRunnerOptions stubRunnerOptions, StubRepository repository, StubConfiguration stubConfiguration) {
        if (this.stubServer != null) {
            if (log.isDebugEnabled()) {
                log.debug("Returning cached version of stubs [" + stubConfiguration.toColonSeparatedDependencyNotation() + "]");
            }
            return this.runningStubs();
        }
        this.startStubServers(stubRunnerOptions, stubConfiguration, repository);
        RunningStubs runningCollaborators = this.runningStubs();
        log.info("All stubs are now running " + runningCollaborators.toString());
        return runningCollaborators;
    }

    private RunningStubs runningStubs() {
        return new RunningStubs(Collections.singletonMap(this.stubServer.getStubConfiguration(), this.stubServer.getPort()));
    }

    public void shutdown() {
        if (this.stubServer != null) {
            this.stubServer.stop();
        }
    }

    @Override
    public URL findStubUrl(String groupId, String artifactId) {
        if (groupId == null) {
            return this.returnStubUrlIfMatches(artifactId.equals(this.stubServer.stubConfiguration.artifactId));
        }
        return this.returnStubUrlIfMatches(artifactId.equals(this.stubServer.stubConfiguration.artifactId) && groupId.equals(this.stubServer.stubConfiguration.groupId));
    }

    @Override
    public URL findStubUrl(String ivyNotation) {
        String[] splitString = ivyNotation.split(":");
        if (splitString.length == 1) {
            throw new IllegalArgumentException("$ivyNotation is invalid");
        }
        return this.findStubUrl(splitString[0], splitString[1]);
    }

    @Override
    public RunningStubs findAllRunningStubs() {
        return new RunningStubs(Collections.singletonMap(this.stubServer.stubConfiguration, this.stubServer.getPort()));
    }

    @Override
    public Map<StubConfiguration, Collection<Contract>> getContracts() {
        return Collections.singletonMap(this.stubServer.stubConfiguration, this.stubServer.getContracts());
    }

    @Override
    public boolean trigger(String ivyNotationAsString, String labelName) {
        ArrayList<Contract> matchingContracts = new ArrayList<Contract>();
        for (Map.Entry<StubConfiguration, Collection<Contract>> it : this.getContracts().entrySet()) {
            if (!it.getKey().groupIdAndArtifactMatches(ivyNotationAsString)) continue;
            matchingContracts.addAll(it.getValue());
        }
        return this.triggerForDsls(matchingContracts, labelName);
    }

    @Override
    public boolean trigger(String labelName) {
        ArrayList<Contract> matchingContracts = new ArrayList<Contract>();
        for (Collection<Contract> it : this.getContracts().values()) {
            matchingContracts.addAll(it);
        }
        return this.triggerForDsls(matchingContracts, labelName);
    }

    private boolean triggerForDsls(Collection<Contract> dsls, String labelName) {
        ArrayList<Contract> matchingDsls = new ArrayList<Contract>();
        for (Contract contract : dsls) {
            if (!labelName.equals(contract.getLabel())) continue;
            matchingDsls.add(contract);
        }
        if (matchingDsls.isEmpty()) {
            return false;
        }
        for (Contract contract : matchingDsls) {
            this.sendMessageIfApplicable(contract);
        }
        return true;
    }

    @Override
    public boolean trigger() {
        ArrayList<Contract> matchingContracts = new ArrayList<Contract>();
        for (Collection<Contract> it : this.getContracts().values()) {
            matchingContracts.addAll(it);
        }
        for (Contract contract : matchingContracts) {
            this.sendMessageIfApplicable(contract);
        }
        return true;
    }

    @Override
    public Map<String, Collection<String>> labels() {
        LinkedHashMap<String, Collection<String>> labels = new LinkedHashMap<String, Collection<String>>();
        for (Map.Entry<StubConfiguration, Collection<Contract>> it : this.getContracts().entrySet()) {
            ArrayList<String> values = new ArrayList<String>();
            for (Contract contract : it.getValue()) {
                values.add(contract.getLabel());
            }
            labels.put(it.getKey().toColonSeparatedDependencyNotation(), values);
        }
        return labels;
    }

    private void sendMessageIfApplicable(Contract groovyDsl) {
        OutputMessage outputMessage = groovyDsl.getOutputMessage();
        if (outputMessage == null) {
            return;
        }
        DslProperty body = outputMessage.getBody();
        Headers headers = outputMessage.getHeaders();
        this.contractVerifierMessaging.send((Object)JsonOutput.toJson((Object)BodyExtractor.extractClientValueFromBody((Object)(body == null ? null : body.getClientValue()))), headers == null ? null : headers.asStubSideMap(), (String)outputMessage.getSentTo().getClientValue());
    }

    private URL returnStubUrlIfMatches(boolean condition) {
        return condition ? this.stubServer.getStubUrl() : null;
    }

    private void startStubServers(StubRunnerOptions stubRunnerOptions, final StubConfiguration stubConfiguration, StubRepository repository) {
        final List<WiremockMappingDescriptor> mappings = repository.getProjectDescriptors();
        final Collection<Contract> contracts = repository.contracts;
        Integer port = stubRunnerOptions.port(stubConfiguration);
        if (!contracts.isEmpty() && !this.hasRequest(contracts)) {
            if (log.isDebugEnabled()) {
                log.debug("There are no HTTP related contracts. Won't start any servers");
            }
            this.stubServer = new StubServer(stubConfiguration, mappings, contracts, new NoOpHttpServerStub());
            return;
        }
        if (contracts.isEmpty()) {
            log.warn("There are no contracts in the published JAR. This is an unusual situation that's why will start the server - maybe you know what you're doing...");
        }
        this.stubServer = port != null && port >= 0 ? new StubServer(stubConfiguration, mappings, contracts, new WireMockHttpServerStub(port)) : this.portScanner.tryToExecuteWithFreePort(new AvailablePortScanner.PortCallback<StubServer>(){

            @Override
            public StubServer call(int availablePort) {
                return new StubServer(stubConfiguration, mappings, contracts, new WireMockHttpServerStub(availablePort));
            }
        });
        this.stubServer = this.stubServer.start();
    }

    private boolean hasRequest(Collection<Contract> contracts) {
        for (Contract contract : contracts) {
            if (contract.getRequest() == null) continue;
            return true;
        }
        return false;
    }
}

