/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubRunner;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;

class StubRunnerFactory {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final StubRunnerOptions stubRunnerOptions;
    private final StubDownloader stubDownloader;
    private final MessageVerifier<?> contractVerifierMessaging;

    public StubRunnerFactory(StubRunnerOptions stubRunnerOptions, StubDownloader stubDownloader, MessageVerifier<?> contractVerifierMessaging) {
        this.stubRunnerOptions = stubRunnerOptions;
        this.stubDownloader = stubDownloader;
        this.contractVerifierMessaging = contractVerifierMessaging;
    }

    public Collection<StubRunner> createStubsFromServiceConfiguration() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will download stubs for dependencies " + this.stubRunnerOptions.getDependencies()));
        }
        if (this.stubRunnerOptions.getDependencies().isEmpty()) {
            log.warn((Object)"No stubs to download have been passed. Most likely you have forgotten to pass them either via annotation or a property");
        }
        ArrayList<StubRunner> result = new ArrayList<StubRunner>();
        for (StubConfiguration stubsConfiguration : this.stubRunnerOptions.getDependencies()) {
            Map.Entry<StubConfiguration, File> entry = this.stubDownloader.downloadAndUnpackStubJar(this.stubRunnerOptions, stubsConfiguration);
            if (log.isDebugEnabled()) {
                log.debug((Object)("For stub configuration [" + stubsConfiguration + "] the downloaded entry is [" + entry + "]"));
            }
            if (entry == null) continue;
            result.add(this.createStubRunner(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    private StubRunner createStubRunner(StubConfiguration stubsConfiguration, File unzipedStubDir) {
        if (unzipedStubDir == null) {
            return null;
        }
        return this.createStubRunner(unzipedStubDir, stubsConfiguration, this.stubRunnerOptions);
    }

    private StubRunner createStubRunner(File unzippedStubsDir, StubConfiguration stubsConfiguration, StubRunnerOptions stubRunnerOptions) {
        return new StubRunner(stubRunnerOptions, unzippedStubsDir.getPath(), stubsConfiguration, this.contractVerifierMessaging);
    }
}

