/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.stubrunner.HttpServerStub;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.WiremockMappingDescriptor;

class StubServer {
    private static final Logger log = LoggerFactory.getLogger(StubServer.class);
    private final HttpServerStub httpServerStub;
    final StubConfiguration stubConfiguration;
    final Collection<WiremockMappingDescriptor> mappings;
    final Collection<Contract> contracts;

    StubServer(StubConfiguration stubConfiguration, Collection<WiremockMappingDescriptor> mappings, Collection<Contract> contracts, HttpServerStub httpServerStub) {
        this.stubConfiguration = stubConfiguration;
        this.mappings = mappings;
        this.httpServerStub = httpServerStub;
        this.contracts = contracts;
    }

    public StubServer start() {
        this.httpServerStub.start();
        log.info("Started stub server for project [" + this.stubConfiguration.toColonSeparatedDependencyNotation() + "] on port " + this.httpServerStub.port());
        this.registerStubMappings();
        return this;
    }

    public void stop() {
        this.httpServerStub.stop();
    }

    public int getPort() {
        if (this.httpServerStub.isRunning()) {
            return this.httpServerStub.port();
        }
        if (log.isDebugEnabled()) {
            log.debug("The HTTP Server stub is not running... That means that the artifact is running a messaging module. Returning back -1 value of the port.");
        }
        return -1;
    }

    public URL getStubUrl() {
        try {
            return new URL("http://localhost:" + this.getPort());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Cannot parse URL", e);
        }
    }

    public StubConfiguration getStubConfiguration() {
        return this.stubConfiguration;
    }

    public Collection<Contract> getContracts() {
        return this.contracts;
    }

    private void registerStubMappings() {
        WireMock wireMock = new WireMock("localhost", this.httpServerStub.port());
        this.registerDefaultHealthChecks(wireMock);
        this.registerStubs(this.mappings, wireMock);
    }

    private void registerDefaultHealthChecks(WireMock wireMock) {
        this.registerHealthCheck(wireMock, "/ping");
        this.registerHealthCheck(wireMock, "/health");
    }

    private void registerStubs(Collection<WiremockMappingDescriptor> sortedMappings, WireMock wireMock) {
        for (WiremockMappingDescriptor mappingDescriptor : sortedMappings) {
            try {
                wireMock.register(mappingDescriptor.getMapping());
                if (!log.isDebugEnabled()) continue;
                log.debug("Registered stub mappings from [" + mappingDescriptor.descriptor + "]");
            }
            catch (Exception e) {
                log.warn("Failed to register the stub mapping [" + mappingDescriptor + "]", (Throwable)e);
            }
        }
    }

    private void registerHealthCheck(WireMock wireMock, String url) {
        this.registerHealthCheck(wireMock, url, "OK");
    }

    private void registerHealthCheck(WireMock wireMock, String url, String body) {
        wireMock.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)url)).willReturn(WireMock.aResponse().withBody(body).withStatus(200)));
    }
}

