/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.messaging.camel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.toomuchcoding.jsonassert.JsonAssertion;
import com.toomuchcoding.jsonassert.JsonVerifiable;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.internal.Header;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierObjectMapper;
import org.springframework.cloud.contract.verifier.util.JsonPaths;
import org.springframework.cloud.contract.verifier.util.JsonToJsonPathsConverter;
import org.springframework.cloud.contract.verifier.util.MethodBufferingJsonVerifiable;

class StubRunnerCamelPredicate
implements Predicate {
    private final Contract groovyDsl;
    private final ContractVerifierObjectMapper objectMapper = new ContractVerifierObjectMapper();

    public StubRunnerCamelPredicate(Contract groovyDsl) {
        this.groovyDsl = groovyDsl;
    }

    public boolean matches(Exchange exchange) {
        DocumentContext parsedJson;
        if (!this.headersMatch(exchange)) {
            return false;
        }
        Object inputMessage = exchange.getIn().getBody();
        JsonPaths jsonPaths = JsonToJsonPathsConverter.transformToJsonPathWithStubsSideValuesAndNoArraySizeCheck((Object)this.groovyDsl.getInput().getMessageBody());
        try {
            parsedJson = JsonPath.parse((String)this.objectMapper.writeValueAsString(inputMessage));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Cannot serialize to JSON", e);
        }
        boolean matches = true;
        for (MethodBufferingJsonVerifiable path : jsonPaths) {
            matches &= this.matchesJsonPath(parsedJson, (JsonVerifiable)path);
        }
        return matches;
    }

    private boolean matchesJsonPath(DocumentContext parsedJson, JsonVerifiable jsonVerifiable) {
        try {
            JsonAssertion.assertThat((DocumentContext)parsedJson).matchesJsonPath(jsonVerifiable.jsonPath());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean headersMatch(Exchange exchange) {
        Map headers = exchange.getIn().getHeaders();
        boolean matches = true;
        for (Header it : this.groovyDsl.getInput().getMessageHeaders().getEntries()) {
            String name = it.getName();
            Object value = it.getClientValue();
            Object valueInHeader = headers.get(name);
            matches &= value instanceof Pattern ? ((Pattern)value).matcher(valueInHeader.toString()).matches() : valueInHeader != null && valueInHeader.equals(value);
        }
        return matches;
    }
}

