/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.messaging.stream;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.toomuchcoding.jsonassert.JsonAssertion;
import com.toomuchcoding.jsonassert.JsonVerifiable;
import java.util.regex.Pattern;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.internal.Header;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierObjectMapper;
import org.springframework.cloud.contract.verifier.util.JsonPaths;
import org.springframework.cloud.contract.verifier.util.JsonToJsonPathsConverter;
import org.springframework.cloud.contract.verifier.util.MethodBufferingJsonVerifiable;
import org.springframework.integration.core.MessageSelector;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;

class StubRunnerStreamMessageSelector
implements MessageSelector {
    private final Contract groovyDsl;
    private final ContractVerifierObjectMapper objectMapper = new ContractVerifierObjectMapper();

    StubRunnerStreamMessageSelector(Contract groovyDsl) {
        this.groovyDsl = groovyDsl;
    }

    public boolean accept(Message<?> message) {
        if (!this.headersMatch(message)) {
            return false;
        }
        Object inputMessage = message.getPayload();
        JsonPaths jsonPaths = JsonToJsonPathsConverter.transformToJsonPathWithStubsSideValuesAndNoArraySizeCheck((Object)this.groovyDsl.getInput().getMessageBody());
        try {
            DocumentContext parsedJson = JsonPath.parse((String)this.objectMapper.writeValueAsString(inputMessage));
            for (MethodBufferingJsonVerifiable it : jsonPaths) {
                if (this.matchesJsonPath(parsedJson, (JsonVerifiable)it)) continue;
                return false;
            }
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Cannot parse JSON", e);
        }
        return true;
    }

    private boolean matchesJsonPath(DocumentContext parsedJson, JsonVerifiable jsonVerifiable) {
        try {
            JsonAssertion.assertThat((DocumentContext)parsedJson).matchesJsonPath(jsonVerifiable.jsonPath());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean headersMatch(Message<?> message) {
        MessageHeaders headers = message.getHeaders();
        for (Header it : this.groovyDsl.getInput().getMessageHeaders().getEntries()) {
            boolean matches;
            String name = it.getName();
            Object value = it.getClientValue();
            Object valueInHeader = headers.get(name);
            if (value instanceof Pattern) {
                Pattern pattern = (Pattern)value;
                matches = pattern.matcher(valueInHeader.toString()).matches();
            } else {
                boolean bl = matches = valueInHeader != null && valueInHeader.equals(value);
            }
            if (matches) continue;
            return false;
        }
        return true;
    }
}

