/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.spring.cloud;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.contract.stubrunner.StubFinder;
import org.springframework.cloud.contract.stubrunner.spring.cloud.ConditionalOnStubbedDiscoveryEnabled;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubMapperProperties;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubRunnerDiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableConfigurationProperties(value={StubMapperProperties.class})
@ConditionalOnClass(value={DiscoveryClient.class})
@ConditionalOnProperty(value={"stubrunner.cloud.enabled"}, matchIfMissing=true)
public class StubRunnerSpringCloudAutoConfiguration {
    @Bean
    @Primary
    @ConditionalOnBean(value={DiscoveryClient.class})
    @ConditionalOnStubbedDiscoveryEnabled
    @ConditionalOnProperty(value={"stubrunner.cloud.delegate.enabled"}, havingValue="true")
    public DiscoveryClient stubRunnerDiscoveryClientWrapper(DiscoveryClient discoveryClient, StubFinder stubFinder, StubMapperProperties stubMapperProperties, @Value(value="${spring.application.name:unknown}") String springAppName) {
        return new StubRunnerDiscoveryClient(discoveryClient, stubFinder, stubMapperProperties, springAppName);
    }

    @Bean
    @Primary
    @ConditionalOnStubbedDiscoveryEnabled
    @ConditionalOnProperty(value={"stubrunner.cloud.delegate.enabled"}, havingValue="false", matchIfMissing=true)
    public DiscoveryClient noOpStubRunnerDiscoveryClient(StubFinder stubFinder, StubMapperProperties stubMapperProperties, @Value(value="${spring.application.name:unknown}") String springAppName) {
        return new StubRunnerDiscoveryClient(stubFinder, stubMapperProperties, springAppName);
    }
}

