/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.File;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.LocalRepository;
import shaded.org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import shaded.org.apache.maven.settings.Settings;
import shaded.org.apache.maven.settings.building.DefaultSettingsBuilder;
import shaded.org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import shaded.org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import shaded.org.apache.maven.settings.building.SettingsBuildingException;
import shaded.org.apache.maven.settings.building.SettingsBuildingRequest;
import shaded.org.apache.maven.settings.building.SettingsBuildingResult;
import shaded.org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import shaded.org.eclipse.aether.impl.DefaultServiceLocator;
import shaded.org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import shaded.org.eclipse.aether.spi.connector.transport.TransporterFactory;
import shaded.org.eclipse.aether.transport.file.FileTransporterFactory;
import shaded.org.eclipse.aether.transport.http.HttpTransporterFactory;

class AetherFactories {
    private static final String MAVEN_LOCAL_REPOSITORY_LOCATION = "maven.repo.local";
    private static final String MAVEN_USER_SETTINGS_LOCATION = "org.apache.maven.user-settings";
    private static final String MAVEN_GLOBAL_SETTINGS_LOCATION = "org.apache.maven.global-settings";

    AetherFactories() {
    }

    public static RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    public static RepositorySystemSession newSession(RepositorySystem system, boolean workOffline) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setOffline(workOffline);
        if (!workOffline) {
            session.setUpdatePolicy("always");
        }
        session.setChecksumPolicy("warn");
        LocalRepository localRepo = new LocalRepository(AetherFactories.localRepositoryDirectory());
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        return session;
    }

    private static String localRepositoryDirectory() {
        String localRepoLocationFromSettings = AetherFactories.settings().getLocalRepository();
        return System.getProperty(MAVEN_LOCAL_REPOSITORY_LOCATION, localRepoLocationFromSettings != null ? localRepoLocationFromSettings : System.getProperty("user.home") + File.separator + ".m2" + File.separator + "repository");
    }

    private static Settings settings() {
        SettingsBuildingResult result;
        DefaultSettingsBuilder builder = new DefaultSettingsBuilderFactory().newInstance();
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        String user = System.getProperty(MAVEN_USER_SETTINGS_LOCATION);
        if (user == null) {
            request.setUserSettingsFile(new File(new File(System.getProperty("user.home")).getAbsoluteFile(), File.separator + ".m2" + File.separator + "settings.xml"));
        } else {
            request.setUserSettingsFile(new File(user));
        }
        String global = System.getProperty(MAVEN_GLOBAL_SETTINGS_LOCATION);
        if (global != null) {
            request.setGlobalSettingsFile(new File(global));
        }
        try {
            result = builder.build((SettingsBuildingRequest)request);
        }
        catch (SettingsBuildingException ex) {
            throw new IllegalStateException(ex);
        }
        return result.getEffectiveSettings();
    }
}

