/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.spring;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.contract.stubrunner.BatchStubRunner;
import org.springframework.cloud.contract.stubrunner.BatchStubRunnerFactory;
import org.springframework.cloud.contract.stubrunner.RunningStubs;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilder;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilderProvider;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptionsBuilder;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerPortBeanPostProcessor;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.noop.NoOpStubMessages;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={StubRunnerProperties.class})
@ConditionalOnMissingBean(type={"org.springframework.cloud.contract.wiremock.WiremockServerConfiguration"})
@Import(value={StubRunnerPortBeanPostProcessor.class})
public class StubRunnerConfiguration {
    static final String STUBRUNNER_PREFIX = "stubrunner.runningstubs";
    @Autowired(required=false)
    private MessageVerifier<?> contractVerifierMessaging;
    private StubDownloaderBuilderProvider provider = new StubDownloaderBuilderProvider();
    @Autowired
    private StubRunnerProperties props;
    @Autowired
    private ConfigurableEnvironment environment;

    @Bean
    public BatchStubRunner batchStubRunner() throws IOException {
        StubRunnerOptionsBuilder builder = this.builder();
        if (this.props.getProxyHost() != null) {
            builder.withProxy(this.props.getProxyHost(), this.props.getProxyPort());
        }
        StubRunnerOptions stubRunnerOptions = builder.build();
        BatchStubRunner batchStubRunner = new BatchStubRunnerFactory(stubRunnerOptions, this.provider.get(stubRunnerOptions, new StubDownloaderBuilder[0]), (MessageVerifier<?>)(this.contractVerifierMessaging != null ? this.contractVerifierMessaging : new NoOpStubMessages())).buildBatchStubRunner();
        RunningStubs runningStubs = batchStubRunner.runStubs();
        this.registerPort(runningStubs);
        return batchStubRunner;
    }

    private StubRunnerOptionsBuilder builder() throws IOException {
        return new StubRunnerOptionsBuilder().withMinMaxPort(this.props.getMinPort(), this.props.getMaxPort()).withStubRepositoryRoot(this.props.getRepositoryRoot()).withStubsMode(this.props.getStubsMode()).withStubsClassifier(this.props.getClassifier()).withStubs(this.props.getIds()).withUsername(this.props.getUsername()).withPassword(this.props.getPassword()).withStubPerConsumer(this.props.isStubsPerConsumer()).withConsumerName(this.consumerName()).withMappingsOutputFolder(this.props.getMappingsOutputFolder()).withDeleteStubsAfterTest(this.props.isDeleteStubsAfterTest()).withProperties(this.props.getProperties());
    }

    private String consumerName() {
        if (StringUtils.hasText((String)this.props.getConsumerName())) {
            return this.props.getConsumerName();
        }
        return this.environment.getProperty("spring.application.name");
    }

    private void registerPort(RunningStubs runStubs) {
        MutablePropertySources propertySources = this.environment.getPropertySources();
        if (!propertySources.contains(STUBRUNNER_PREFIX)) {
            propertySources.addFirst((PropertySource)new MapPropertySource(STUBRUNNER_PREFIX, new HashMap()));
        }
        Map source = (Map)((MapPropertySource)propertySources.get(STUBRUNNER_PREFIX)).getSource();
        for (Map.Entry<StubConfiguration, Integer> entry : runStubs.validNamesAndPorts().entrySet()) {
            source.put("stubrunner.runningstubs." + entry.getKey().getArtifactId() + ".port", entry.getValue());
            source.put("stubrunner.runningstubs." + entry.getKey().getGroupId() + "." + entry.getKey().getArtifactId() + ".port", entry.getValue());
        }
    }
}

