/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.messaging.camel;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.internal.FromFileProperty;
import org.springframework.cloud.contract.spec.internal.Header;
import org.springframework.cloud.contract.stubrunner.messaging.camel.StubRunnerCamelPayload;
import org.springframework.cloud.contract.verifier.util.BodyExtractor;

class StubRunnerCamelProcessor
implements Processor {
    private static final Log log = LogFactory.getLog(StubRunnerCamelProcessor.class);
    private static final String DUMMY_BEAN_URL = "bean:dummyStubRunnerProcessor";

    StubRunnerCamelProcessor() {
    }

    public void process(Exchange exchange) {
        Message input = exchange.getIn();
        StubRunnerCamelPayload body = (StubRunnerCamelPayload)input.getBody(StubRunnerCamelPayload.class);
        Contract groovyDsl = body.contract;
        this.setStubRunnerDestinationHeader(exchange, body);
        if (groovyDsl.getInput().getMessageHeaders() != null) {
            for (Header entry : groovyDsl.getInput().getMessageHeaders().getEntries()) {
                input.removeHeader(entry.getName());
            }
        }
        if (groovyDsl.getOutputMessage() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No output message provided, will not modify the body");
            }
            return;
        }
        input.setBody(this.outputBody(groovyDsl));
        if (groovyDsl.getOutputMessage().getHeaders() != null) {
            for (Header entry : groovyDsl.getOutputMessage().getHeaders().getEntries()) {
                input.setHeader(entry.getName(), entry.getClientValue());
            }
        }
    }

    private Object outputBody(Contract groovyDsl) {
        Object outputBody = BodyExtractor.extractClientValueFromBody((Object)groovyDsl.getOutputMessage().getBody());
        if (outputBody instanceof FromFileProperty) {
            FromFileProperty property = (FromFileProperty)outputBody;
            return property.asBytes();
        }
        return BodyExtractor.extractStubValueFrom((Object)outputBody);
    }

    private void setStubRunnerDestinationHeader(Exchange exchange, StubRunnerCamelPayload body) {
        boolean outputPart = body.contract.getOutputMessage() != null;
        String url = DUMMY_BEAN_URL;
        if (outputPart && body.contract.getOutputMessage().getSentTo() != null) {
            url = (String)body.contract.getOutputMessage().getSentTo().getClientValue();
        }
        exchange.getIn().setHeader("STUBRUNNER_DESTINATION_URL", (Object)url);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set stub runner destination header to [" + url + "]"));
        }
    }
}

