/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.stubrunner.DirectoryCopyingVisitor;
import org.springframework.cloud.contract.stubrunner.GitContractsRepo;
import org.springframework.cloud.contract.stubrunner.GitRepo;
import org.springframework.cloud.contract.stubrunner.GitStubDownloaderProperties;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.StubRunnerPropertyUtils;
import org.springframework.util.StringUtils;

public class ContractProjectUpdater {
    private static final Log log = LogFactory.getLog(ContractProjectUpdater.class);
    private static final int DEFAULT_ATTEMPTS_NO = 10;
    private static final long DEFAULT_WAIT_BETWEEN_ATTEMPTS = 1000L;
    private static final String DEFAULT_COMMIT_MESSAGE = "Updating project [$project] with stubs";
    private static final String GIT_ATTEMPTS_NO_PROP = "git.no-of-attempts";
    private static final String GIT_WAIT_BETWEEN_ATTEMPTS = "git.wait-between-attempts";
    private static final String GIT_COMMIT_MESSAGE = "git.commit-message";
    private final StubRunnerOptions stubRunnerOptions;
    private final GitContractsRepo gitContractsRepo;

    public ContractProjectUpdater(StubRunnerOptions stubRunnerOptions) {
        this.stubRunnerOptions = stubRunnerOptions;
        this.gitContractsRepo = new GitContractsRepo(stubRunnerOptions);
    }

    public void updateContractProject(String projectName, Path rootStubsFolder) {
        File clonedRepo = this.gitContractsRepo.clonedRepo(this.stubRunnerOptions.stubRepositoryRoot);
        GitStubDownloaderProperties properties = new GitStubDownloaderProperties(this.stubRunnerOptions.stubRepositoryRoot, this.stubRunnerOptions);
        this.copyStubs(projectName, rootStubsFolder, clonedRepo);
        GitRepo gitRepo = new GitRepo(clonedRepo, properties);
        String msg = StubRunnerPropertyUtils.getProperty(this.stubRunnerOptions.getProperties(), GIT_COMMIT_MESSAGE);
        GitRepo.CommitResult commit = gitRepo.commit(clonedRepo, this.commitMessage(projectName, msg));
        if (commit == GitRepo.CommitResult.EMPTY) {
            log.info((Object)"There were no changes to commit. Won't push the changes");
            return;
        }
        String attempts = StubRunnerPropertyUtils.getProperty(this.stubRunnerOptions.getProperties(), GIT_ATTEMPTS_NO_PROP);
        int intAttempts = StringUtils.hasText((String)attempts) ? Integer.parseInt(attempts) : 10;
        String wait = StubRunnerPropertyUtils.getProperty(this.stubRunnerOptions.getProperties(), GIT_WAIT_BETWEEN_ATTEMPTS);
        long longWait = StringUtils.hasText((String)wait) ? Long.parseLong(wait) : 1000L;
        this.tryToPushCurrentBranch(clonedRepo, gitRepo, intAttempts, longWait);
    }

    private void tryToPushCurrentBranch(File clonedRepo, GitRepo gitRepo, int intAttempts, long longWait) {
        int currentAttempt = 0;
        while (currentAttempt < intAttempts) {
            log.info((Object)("Trying to push changes, attempt " + (currentAttempt + 1) + "/" + intAttempts));
            gitRepo.pull(clonedRepo);
            log.info((Object)"Successfully pulled changes from remote for project with contract and stubs");
            try {
                gitRepo.pushCurrentBranch(clonedRepo);
                log.info((Object)"Successfully pushed changes with current stubs");
                break;
            }
            catch (IllegalStateException e) {
                log.error((Object)"Exception occurred while trying to push the changes", (Throwable)e);
                if (++currentAttempt == intAttempts) {
                    throw new IllegalStateException("Failed to push changes to the project with contracts and stubs. Exceeded number of retries [" + intAttempts + "]");
                }
                try {
                    Thread.sleep(longWait);
                }
                catch (InterruptedException e1) {
                    throw new IllegalStateException(e1);
                }
            }
        }
    }

    private String commitMessage(String projectName, String msg) {
        return StringUtils.hasText((String)msg) ? this.replaceProject(projectName, msg) : this.replaceProject(projectName, DEFAULT_COMMIT_MESSAGE);
    }

    private String replaceProject(String projectName, String msg) {
        return msg.replace("$project", projectName);
    }

    private void copyStubs(String projectName, Path rootStubsFolder, File clonedRepo) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Copying stubs from [" + rootStubsFolder.toString() + "] to the cloned repo [" + clonedRepo.getAbsolutePath() + "] for project [" + projectName + "]"));
            }
            Files.walkFileTree(rootStubsFolder, new DirectoryCopyingVisitor(rootStubsFolder, clonedRepo.toPath()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully copied stubs to the cloned repo for project [" + projectName + "]"));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

