/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.spring;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.contract.verifier.converter.YamlContract;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifierReceiver;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifierSender;
import org.springframework.cloud.contract.verifier.messaging.noop.NoOpStubMessages;

class LazyMessageVerifier
implements MessageVerifierSender,
MessageVerifierReceiver {
    private MessageVerifierSender<?> messageVerifierSender;
    private MessageVerifierReceiver<?> messageVerifierReceiver;
    private final BeanFactory beanFactory;

    LazyMessageVerifier(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    private MessageVerifierSender messageVerifierSender() {
        if (this.messageVerifierSender == null) {
            this.messageVerifierSender = (MessageVerifierSender)this.beanFactory.getBeanProvider(MessageVerifierSender.class).getIfAvailable(NoOpStubMessages::new);
        }
        return this.messageVerifierSender;
    }

    private MessageVerifierReceiver messageVerifierReceiver() {
        if (this.messageVerifierReceiver == null) {
            this.messageVerifierReceiver = (MessageVerifierReceiver)this.beanFactory.getBeanProvider(MessageVerifierReceiver.class).getIfAvailable(NoOpStubMessages::new);
        }
        return this.messageVerifierReceiver;
    }

    public void send(Object message, String destination, YamlContract contract) {
        this.messageVerifierSender().send(message, destination, contract);
    }

    public Object receive(String destination, long timeout, TimeUnit timeUnit, YamlContract contract) {
        return this.messageVerifierReceiver().receive(destination, timeout, timeUnit, contract);
    }

    public Object receive(String destination, YamlContract contract) {
        return this.messageVerifierReceiver().receive(destination, contract);
    }

    public void send(Object payload, Map headers, String destination, YamlContract contract) {
        this.messageVerifierSender().send(payload, headers, destination, contract);
    }
}

