/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.util;

import groovy.json.JsonException;
import groovy.json.JsonOutput;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.util.XmlSlurper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.text.StringEscapeUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.ExecutionProperty;
import org.springframework.cloud.contract.spec.internal.FromFileProperty;
import org.springframework.cloud.contract.spec.internal.Header;
import org.springframework.cloud.contract.spec.internal.Headers;
import org.springframework.cloud.contract.spec.internal.MatchingStrategy;
import org.springframework.cloud.contract.spec.internal.NamedProperty;
import org.springframework.cloud.contract.spec.internal.OptionalProperty;
import org.springframework.cloud.contract.verifier.util.ContentType;
import org.springframework.cloud.contract.verifier.util.MapConverter;

public class ContentUtils
implements GroovyObject {
    private static final Log log;
    public static final Closure GET_STUB_SIDE;
    public static final Closure GET_TEST_SIDE;
    private static final Pattern TEMPORARY_PATTERN_HOLDER;
    private static final Pattern TEMPORARY_EXECUTION_PATTERN_HOLDER;
    private static final Pattern TEMPORARY_OPTIONAL_PATTERN_HOLDER;
    private static final String JSON_VALUE_PATTERN_FOR_REGEX = "REGEXP>>%s<<";
    private static final String JSON_VALUE_PATTERN_FOR_OPTIONAL = "OPTIONAL>>%s<<";
    private static final String JSON_VALUE_PATTERN_FOR_EXECUTION = "\"EXECUTION>>%s<<\"";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public ContentUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    /*
     * Loose catch block
     */
    public static Object extractValue(GString bodyAsValue, ContentType contentType, Closure valueProvider) {
        if (ShortTypeHandling.castToString((Object)bodyAsValue).isEmpty()) {
            return bodyAsValue;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)contentType), (Object)((Object)ContentType.TEXT)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)contentType), (Object)((Object)ContentType.FORM))) {
            return ContentUtils.extractValueForText(bodyAsValue, valueProvider);
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)ContentType.JSON), (Object)((Object)contentType))) {
            return ContentUtils.extractValueForJSON(bodyAsValue, valueProvider);
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)contentType), (Object)((Object)ContentType.XML))) {
            return ContentUtils.extractValueForXML(bodyAsValue, valueProvider);
        }
        log.trace((Object)"No content type provided so trying to parse as JSON");
        Object object = ContentUtils.extractValueForJSON(bodyAsValue, valueProvider);
        try {
            return object;
        }
        catch (JsonException e) {
            log.trace((Object)"Failed to parse as JSON - trying to parse as XML", (Throwable)e);
            GStringImpl gStringImpl = ContentUtils.extractValueForXML(bodyAsValue, valueProvider);
            return gStringImpl;
            {
                catch (Exception exception) {
                    log.trace((Object)"No content type provided and failed to parse as XML - returning the value back to the user", (Throwable)exception);
                    GStringImpl gStringImpl2 = ContentUtils.extractValueForGString(bodyAsValue, valueProvider);
                    return gStringImpl2;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public static ContentType getClientContentType(GString bodyAsValue) {
        ContentUtils.extractValueForJSON(bodyAsValue, GET_STUB_SIDE);
        ContentType contentType = ContentType.JSON;
        try {
            return contentType;
        }
        catch (JsonException e) {
            new XmlSlurper().parseText(ContentUtils.extractValueForXML(bodyAsValue, GET_STUB_SIDE).toString());
            ContentType contentType2 = ContentType.XML;
            return contentType2;
            {
                catch (Exception ignored) {
                    ContentUtils.extractValueForGString(bodyAsValue, GET_STUB_SIDE);
                    ContentType contentType3 = ContentType.UNKNOWN;
                    return contentType3;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public static ContentType getClientContentType(String bodyAsValue) {
        new JsonSlurper().parseText(bodyAsValue);
        ContentType contentType = ContentType.JSON;
        try {
            return contentType;
        }
        catch (JsonException e) {
            new XmlSlurper().parseText(bodyAsValue);
            ContentType contentType2 = ContentType.XML;
            return contentType2;
            {
                catch (Exception ignored) {
                    ContentType contentType3 = ContentType.UNKNOWN;
                    return contentType3;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
        }
    }

    public static ContentType getClientContentType(Object bodyAsValue) {
        if (bodyAsValue instanceof GString) {
            return ContentUtils.getClientContentType((GString)ScriptBytecodeAdapter.castToType((Object)bodyAsValue, GString.class));
        }
        if (bodyAsValue instanceof String) {
            return ContentUtils.getClientContentType(ShortTypeHandling.castToString((Object)bodyAsValue));
        }
        if (bodyAsValue instanceof Map) {
            return ContentUtils.getClientContentType((Map)ScriptBytecodeAdapter.castToType((Object)bodyAsValue, Map.class));
        }
        if (bodyAsValue instanceof List) {
            return ContentUtils.getClientContentType((List)ScriptBytecodeAdapter.castToType((Object)bodyAsValue, List.class));
        }
        if (bodyAsValue instanceof MatchingStrategy) {
            return ContentType.UNKNOWN;
        }
        if (bodyAsValue instanceof FromFileProperty) {
            return ContentType.UNKNOWN;
        }
        return ContentUtils.tryToGuessContentType(bodyAsValue);
    }

    private static ContentType tryToGuessContentType(Object bodyAsValue) {
        block6: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No content type passed, will try to guess the type of payload");
            }
            ContentType contentType = ContentUtils.getClientContentType(JsonOutput.toJson((Object)bodyAsValue));
            try {
                return contentType;
            }
            catch (Exception ignored) {
                if (!log.isTraceEnabled()) break block6;
                log.trace((Object)StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)"Failed to assume that body [", (Object)bodyAsValue), (CharSequence)"] is json"));
            }
        }
        return ContentType.UNKNOWN;
    }

    public static ContentType getClientContentType(Object bodyAsValue, Headers headers) {
        ContentType contentType = ContentUtils.recognizeContentTypeFromHeader(headers);
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)contentType), (Object)((Object)ContentType.UNKNOWN))) {
            return ContentUtils.getClientContentType(bodyAsValue);
        }
        return contentType;
    }

    public static ContentType getClientContentType(Map bodyAsValue) {
        JsonOutput.toJson((Map)bodyAsValue);
        ContentType contentType = ContentType.JSON;
        try {
            return contentType;
        }
        catch (Exception ignore) {
            ContentType contentType2 = ContentType.UNKNOWN;
            return contentType2;
        }
    }

    public static ContentType getClientContentType(List bodyAsValue) {
        JsonOutput.toJson((Object)bodyAsValue);
        ContentType contentType = ContentType.JSON;
        try {
            return contentType;
        }
        catch (Exception ignore) {
            ContentType contentType2 = ContentType.UNKNOWN;
            return contentType2;
        }
    }

    public static GStringImpl extractValueForGString(GString bodyAsValue, Closure valueProvider) {
        Reference valueProvider2 = new Reference((Object)valueProvider);
        public class _extractValueForGString_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference valueProvider;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _extractValueForGString_closure1(Object _outerInstance, Object _thisObject, Reference valueProvider) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.valueProvider = reference = valueProvider;
            }

            public Object doCall(Object it) {
                return it instanceof DslProperty ? ((Closure)this.valueProvider.get()).call(it) : it;
            }

            public Closure getValueProvider() {
                return (Closure)ScriptBytecodeAdapter.castToType((Object)this.valueProvider.get(), Closure.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractValueForGString_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return new GStringImpl((Object[])ScriptBytecodeAdapter.castToType((Object)((String[])ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.collect((Object)bodyAsValue.getValues(), (Closure)new _extractValueForGString_closure1(ContentUtils.class, ContentUtils.class, valueProvider2)), String[].class)), Object[].class), (String[])ScriptBytecodeAdapter.asType((Object)bodyAsValue.getStrings().clone(), String[].class));
    }

    public static Object extractValue(GString bodyAsValue, Closure valueProvider) {
        return ContentUtils.extractValue(bodyAsValue, ContentType.UNKNOWN, valueProvider);
    }

    private static String extractValueForText(GString bodyAsValue, Closure valueProvider) {
        Reference valueProvider2 = new Reference((Object)valueProvider);
        public class _extractValueForText_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference valueProvider;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _extractValueForText_closure2(Object _outerInstance, Object _thisObject, Reference valueProvider) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.valueProvider = reference = valueProvider;
            }

            public Object doCall(Object it) {
                return ((Closure)this.valueProvider.get()).call(it);
            }

            public Closure getValueProvider() {
                return (Closure)ScriptBytecodeAdapter.castToType((Object)this.valueProvider.get(), Closure.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractValueForText_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        GStringImpl transformedString = new GStringImpl((Object[])ScriptBytecodeAdapter.castToType((Object)((String[])ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.collect((Object)bodyAsValue.getValues(), (Closure)new _extractValueForText_closure2(ContentUtils.class, ContentUtils.class, valueProvider2)), String[].class)), Object[].class), (String[])ScriptBytecodeAdapter.asType((Object)bodyAsValue.getStrings().clone(), String[].class));
        return transformedString.toString();
    }

    private static Object extractValueForJSON(GString bodyAsValue, Closure valueProvider) {
        Reference valueProvider2 = new Reference((Object)valueProvider);
        public class _extractValueForJSON_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference valueProvider;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _extractValueForJSON_closure3(Object _outerInstance, Object _thisObject, Reference valueProvider) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.valueProvider = reference = valueProvider;
            }

            public Object doCall(Object it) {
                return InvokerHelper.invokeStaticMethod(ContentUtils.class, (String)"transformJSONStringValue", (Object)new Object[]{it, this.valueProvider.get()});
            }

            public Closure getValueProvider() {
                return (Closure)ScriptBytecodeAdapter.castToType((Object)this.valueProvider.get(), Closure.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractValueForJSON_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        GStringImpl transformedString = new GStringImpl((Object[])ScriptBytecodeAdapter.castToType((Object)((String[])ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.collect((Object)bodyAsValue.getValues(), (Closure)new _extractValueForJSON_closure3(ContentUtils.class, ContentUtils.class, valueProvider2)), String[].class)), Object[].class), (String[])ScriptBytecodeAdapter.asType((Object)bodyAsValue.getStrings().clone(), String[].class));
        Object parsedJson = new JsonSlurper().parseText(transformedString.toString().replace("\\", "\\\\"));
        return ContentUtils.convertAllTemporaryRegexPlaceholdersBackToPatterns(parsedJson);
    }

    private static GStringImpl extractValueForXML(GString bodyAsValue, Closure valueProvider) {
        Reference valueProvider2 = new Reference((Object)valueProvider);
        public class _extractValueForXML_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference valueProvider;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _extractValueForXML_closure4(Object _outerInstance, Object _thisObject, Reference valueProvider) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.valueProvider = reference = valueProvider;
            }

            public Object doCall(Object it) {
                return ContentUtils.transformXMLStringValue(it, (Closure)ScriptBytecodeAdapter.castToType((Object)this.valueProvider.get(), Closure.class));
            }

            public Closure getValueProvider() {
                return (Closure)ScriptBytecodeAdapter.castToType((Object)this.valueProvider.get(), Closure.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractValueForXML_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        GStringImpl impl = new GStringImpl((Object[])ScriptBytecodeAdapter.castToType((Object)((String[])ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.collect((Object)bodyAsValue.getValues(), (Closure)new _extractValueForXML_closure4(ContentUtils.class, ContentUtils.class, valueProvider2)), String[].class)), Object[].class), (String[])ScriptBytecodeAdapter.asType((Object)bodyAsValue.getStrings().clone(), String[].class));
        new XmlSlurper().parseText(impl.toString());
        return impl;
    }

    protected static Object transformJSONStringValue(Object obj, Closure valueProvider) {
        if (obj instanceof DslProperty) {
            return ContentUtils.transformJSONStringValue((DslProperty)ScriptBytecodeAdapter.castToType((Object)obj, DslProperty.class), valueProvider);
        }
        if (obj instanceof Pattern) {
            return ContentUtils.transformJSONStringValue((Pattern)ScriptBytecodeAdapter.castToType((Object)obj, Pattern.class), valueProvider);
        }
        if (obj instanceof OptionalProperty) {
            return ContentUtils.transformJSONStringValue((OptionalProperty)ScriptBytecodeAdapter.castToType((Object)obj, OptionalProperty.class), valueProvider);
        }
        if (obj instanceof ExecutionProperty) {
            return ContentUtils.transformJSONStringValue((ExecutionProperty)ScriptBytecodeAdapter.castToType((Object)obj, ExecutionProperty.class), valueProvider);
        }
        return obj;
    }

    protected static Object transformJSONStringValue(DslProperty dslProperty, Closure valueProvider) {
        return ContentUtils.transformJSONStringValue(valueProvider.call((Object)dslProperty), valueProvider);
    }

    protected static Object transformJSONStringValue(Pattern pattern, Closure valueProvider) {
        return String.format(JSON_VALUE_PATTERN_FOR_REGEX, pattern.pattern());
    }

    protected static Object transformJSONStringValue(OptionalProperty optional, Closure valueProvider) {
        return String.format(JSON_VALUE_PATTERN_FOR_OPTIONAL, optional.getValue());
    }

    protected static Object transformJSONStringValue(ExecutionProperty property, Closure valueProvider) {
        return String.format(JSON_VALUE_PATTERN_FOR_EXECUTION, property.getExecutionCommand());
    }

    private static String transformXMLStringValue(Object obj, Closure valueProvider) {
        if (obj instanceof DslProperty) {
            return ShortTypeHandling.castToString((Object)ContentUtils.transformJSONStringValue((DslProperty)ScriptBytecodeAdapter.castToType((Object)obj, DslProperty.class), valueProvider));
        }
        return StringEscapeUtils.escapeXml11((String)StringEscapeUtils.unescapeXml((String)DefaultGroovyMethods.toString((Object)obj)));
    }

    private static String transformXMLStringValue(DslProperty dslProperty, Closure valueProvider) {
        return ContentUtils.transformXMLStringValue(valueProvider.call((Object)dslProperty), valueProvider);
    }

    protected static Object convertDslPropsToTemporaryRegexPatterns(Object parsedJson, Closure parsingClosure) {
        public class _convertDslPropsToTemporaryRegexPatterns_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _convertDslPropsToTemporaryRegexPatterns_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object value) {
                return InvokerHelper.invokeStaticMethod(ContentUtils.class, (String)"transformJSONStringValue", (Object)new Object[]{value, GET_TEST_SIDE});
            }

            public Object call(Object value) {
                return this.doCall(value);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _convertDslPropsToTemporaryRegexPatterns_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return MapConverter.transformValues(parsedJson, new _convertDslPropsToTemporaryRegexPatterns_closure5(ContentUtils.class, ContentUtils.class), parsingClosure);
    }

    private static Object convertAllTemporaryRegexPlaceholdersBackToPatterns(Object parsedJson) {
        public class _convertAllTemporaryRegexPlaceholdersBackToPatterns_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _convertAllTemporaryRegexPlaceholdersBackToPatterns_closure6(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object value) {
                if (value instanceof String) {
                    String string = ShortTypeHandling.castToString((Object)value);
                    return ContentUtils.returnParsedObject(string);
                }
                return value;
            }

            public Object call(Object value) {
                return this.doCall(value);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _convertAllTemporaryRegexPlaceholdersBackToPatterns_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return MapConverter.transformValues(parsedJson, new _convertAllTemporaryRegexPlaceholdersBackToPatterns_closure6(ContentUtils.class, ContentUtils.class));
    }

    public static Object returnParsedObject(Object object) {
        if (!(object instanceof String)) {
            return object;
        }
        String string = ShortTypeHandling.castToString((Object)object);
        Matcher matcher = TEMPORARY_PATTERN_HOLDER.matcher(string.trim());
        if (matcher.matches()) {
            return Pattern.compile(ContentUtils.patternFromMatchingGroup(matcher));
        }
        Matcher executionMatcher = TEMPORARY_EXECUTION_PATTERN_HOLDER.matcher(string.trim());
        if (executionMatcher.matches()) {
            return new ExecutionProperty(ContentUtils.patternFromMatchingGroup(executionMatcher));
        }
        Matcher optionalMatcher = TEMPORARY_OPTIONAL_PATTERN_HOLDER.matcher(string.trim());
        if (optionalMatcher.matches()) {
            String patternToMatch = ContentUtils.patternFromMatchingGroup(optionalMatcher);
            return Pattern.compile(new OptionalProperty((Object)patternToMatch).optionalPattern());
        }
        return string;
    }

    private static String patternFromMatchingGroup(Matcher matcher) {
        List val = (List)ScriptBytecodeAdapter.asType((Object)StringGroovyMethods.getAt((Matcher)matcher, (int)0), List.class);
        return ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((List)val, (int)1));
    }

    public static ContentType recognizeContentTypeFromHeader(Headers headers, Closure<Object> closure) {
        Headers headers2 = headers;
        Set set = headers2 != null ? headers2.getEntries() : null;
        public class _recognizeContentTypeFromHeader_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _recognizeContentTypeFromHeader_closure7(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((Header)it).getName(), (Object)"Content-Type") || ScriptBytecodeAdapter.compareEqual((Object)((Header)it).getName(), (Object)"contentType");
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _recognizeContentTypeFromHeader_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Header header = (Header)ScriptBytecodeAdapter.castToType(set != null ? DefaultGroovyMethods.find((Collection)set, (Closure)new _recognizeContentTypeFromHeader_closure7(ContentUtils.class, ContentUtils.class)) : null, Header.class);
        Object object = closure.call((Object)header);
        String content = object != null ? DefaultGroovyMethods.toString((Object)object) : null;
        String string = content;
        Boolean bl = string != null ? Boolean.valueOf(string.contains("json")) : null;
        if (bl == null ? false : bl) {
            return ContentType.JSON;
        }
        String string2 = content;
        Boolean bl2 = string2 != null ? Boolean.valueOf(string2.contains("xml")) : null;
        if (bl2 == null ? false : bl2) {
            return ContentType.XML;
        }
        String string3 = content;
        Boolean bl3 = string3 != null ? Boolean.valueOf(string3.contains("text")) : null;
        if (bl3 == null ? false : bl3) {
            return ContentType.TEXT;
        }
        String string4 = content;
        Boolean bl4 = string4 != null ? Boolean.valueOf(string4.contains("form-urlencoded")) : null;
        if (bl4 == null ? false : bl4) {
            return ContentType.FORM;
        }
        return ContentType.UNKNOWN;
    }

    public static ContentType recognizeContentTypeFromHeader(Headers headers) {
        public class _recognizeContentTypeFromHeader_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _recognizeContentTypeFromHeader_closure8(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Header header) {
                Header header2 = header;
                return header2 != null ? header2.getClientValue() : null;
            }

            public Object call(Header header) {
                return this.doCall(header);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _recognizeContentTypeFromHeader_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return ContentUtils.recognizeContentTypeFromHeader(headers, new _recognizeContentTypeFromHeader_closure8(ContentUtils.class, ContentUtils.class));
    }

    public static ContentType recognizeContentTypeFromTestHeader(Headers headers) {
        public class _recognizeContentTypeFromTestHeader_closure9
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _recognizeContentTypeFromTestHeader_closure9(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Header header) {
                Header header2 = header;
                return header2 != null ? header2.getServerValue() : null;
            }

            public Object call(Header header) {
                return this.doCall(header);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _recognizeContentTypeFromTestHeader_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return ContentUtils.recognizeContentTypeFromHeader(headers, new _recognizeContentTypeFromTestHeader_closure9(ContentUtils.class, ContentUtils.class));
    }

    public static MatchingStrategy.Type getEqualsTypeFromContentType(ContentType contentType) {
        ContentType contentType2 = contentType;
        if (ScriptBytecodeAdapter.isCase((Object)((Object)contentType2), (Object)((Object)ContentType.JSON))) {
            return MatchingStrategy.Type.EQUAL_TO_JSON;
        }
        if (ScriptBytecodeAdapter.isCase((Object)((Object)contentType2), (Object)((Object)ContentType.XML))) {
            return MatchingStrategy.Type.EQUAL_TO_XML;
        }
        return MatchingStrategy.Type.EQUAL_TO;
    }

    public static ContentType recognizeContentTypeFromContent(GString gstring) {
        if (ContentUtils.isJsonType(gstring)) {
            return ContentType.JSON;
        }
        if (ContentUtils.isXmlType(gstring)) {
            return ContentType.XML;
        }
        return ContentType.UNKNOWN;
    }

    public static ContentType recognizeContentTypeFromContent(Map jsonMap) {
        return ContentType.JSON;
    }

    public static ContentType recognizeContentTypeFromContent(byte ... bytes) {
        return ContentType.UNKNOWN;
    }

    public static ContentType recognizeContentTypeFromContent(List jsonList) {
        return ContentType.JSON;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ContentType recognizeContentTypeFromContent(String string) {
        try {
            new JsonSlurper().parseText(string);
            return ContentType.JSON;
        }
        catch (Exception ignored) {
            if (!ContentUtils.isXmlType((GString)new GStringImpl(new Object[]{string}, new String[]{"", ""}))) return ContentType.UNKNOWN;
            return ContentType.XML;
        }
    }

    public static ContentType recognizeContentTypeFromContent(Number number) {
        return ContentType.TEXT;
    }

    public static ContentType recognizeContentTypeFromContent(Object object) {
        if (object instanceof GString) {
            return ContentUtils.recognizeContentTypeFromContent((GString)ScriptBytecodeAdapter.castToType((Object)object, GString.class));
        }
        if (object instanceof Map) {
            return ContentUtils.recognizeContentTypeFromContent((Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class));
        }
        if (object instanceof byte[]) {
            return ContentUtils.recognizeContentTypeFromContent((byte[])ScriptBytecodeAdapter.castToType((Object)object, byte[].class));
        }
        if (object instanceof List) {
            return ContentUtils.recognizeContentTypeFromContent((List)ScriptBytecodeAdapter.castToType((Object)object, List.class));
        }
        if (object instanceof String) {
            return ContentUtils.recognizeContentTypeFromContent(ShortTypeHandling.castToString((Object)object));
        }
        if (object instanceof Number) {
            return ContentUtils.recognizeContentTypeFromContent((Number)ScriptBytecodeAdapter.castToType((Object)object, Number.class));
        }
        return ContentType.UNKNOWN;
    }

    public static boolean isJsonType(GString gstring) {
        if (ShortTypeHandling.castToString((Object)gstring).isEmpty()) {
            return false;
        }
        public class _isJsonType_closure10
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _isJsonType_closure10(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return it instanceof String || it instanceof GString ? DefaultGroovyMethods.toString((Object)it) : StringEscapeUtils.escapeJson((String)DefaultGroovyMethods.toString((Object)it));
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isJsonType_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        GStringImpl stringWithoutValues = new GStringImpl((Object[])ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.collect((Object)gstring.getValues(), (Closure)new _isJsonType_closure10(ContentUtils.class, ContentUtils.class)), Object[].class), (String[])ScriptBytecodeAdapter.asType((Object)gstring.getStrings().clone(), String[].class));
        new JsonSlurper().parseText(stringWithoutValues.toString());
        boolean bl = true;
        try {
            return bl;
        }
        catch (JsonException e) {
        }
        return false;
    }

    public static boolean isXmlType(GString gString) {
        public class _isXmlType_closure11
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _isXmlType_closure11(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return it instanceof String || it instanceof GString ? DefaultGroovyMethods.toString((Object)it) : StringEscapeUtils.escapeXml11((String)DefaultGroovyMethods.toString((Object)it));
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isXmlType_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        GStringImpl stringWithoutValues = new GStringImpl((Object[])ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.collect((Object)gString.getValues(), (Closure)new _isXmlType_closure11(ContentUtils.class, ContentUtils.class)), Object[].class), (String[])ScriptBytecodeAdapter.asType((Object)gString.getStrings().clone(), String[].class));
        new XmlSlurper().parseText(stringWithoutValues.toString());
        boolean bl = true;
        try {
            return bl;
        }
        catch (Exception ignored) {
        }
        return false;
    }

    public static ContentType recognizeContentTypeFromMatchingStrategy(MatchingStrategy.Type type) {
        MatchingStrategy.Type type2 = type;
        if (ScriptBytecodeAdapter.isCase((Object)type2, (Object)MatchingStrategy.Type.EQUAL_TO_XML)) {
            return ContentType.XML;
        }
        if (ScriptBytecodeAdapter.isCase((Object)type2, (Object)MatchingStrategy.Type.EQUAL_TO_JSON)) {
            return ContentType.JSON;
        }
        return ContentType.UNKNOWN;
    }

    public static String getGroovyMultipartFileParameterContent(String propertyName, NamedProperty propertyValue, Closure<String> bytesFromFile) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{propertyName, ContentUtils.namedPropertyName(propertyValue, "'")}, new String[]{"'", "', ", ", "}).plus((GString)new GStringImpl(new Object[]{ContentUtils.groovyNamedPropertyValue(propertyValue, "'", bytesFromFile)}, new String[]{"", ""})).plus(ContentUtils.namedContentTypeNameIfPresent(propertyValue, "'")));
    }

    public static String getJavaMultipartFileParameterContent(String propertyName, NamedProperty propertyValue, Closure<String> bytesFromFile) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{StringEscapeUtils.escapeJava((String)propertyName), ContentUtils.namedPropertyName(propertyValue, "\"")}, new String[]{"\"", "\", ", ", "}).plus((GString)new GStringImpl(new Object[]{ContentUtils.javaNamedPropertyValue(propertyValue, "\"", bytesFromFile), ContentUtils.namedContentTypeNameIfPresent(propertyValue, "\"")}, new String[]{"", "", ""})));
    }

    public static String namedPropertyName(NamedProperty property, String quote) {
        return property.getName().getServerValue() instanceof ExecutionProperty ? DefaultGroovyMethods.toString((Object)property.getName().getServerValue()) : StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)quote, (CharSequence)StringEscapeUtils.escapeJava((String)DefaultGroovyMethods.toString((Object)property.getName().getServerValue()))), (CharSequence)quote);
    }

    public static String namedContentTypeNameIfPresent(NamedProperty property, String quote) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)property.getContentType())) {
            return "";
        }
        String contentType = property.getContentType().getServerValue() instanceof ExecutionProperty ? DefaultGroovyMethods.toString((Object)property.getContentType().getServerValue()) : StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)quote, (CharSequence)StringEscapeUtils.escapeJava((String)DefaultGroovyMethods.toString((Object)property.getContentType().getServerValue()))), (CharSequence)quote);
        return StringGroovyMethods.plus((String)", ", (CharSequence)contentType);
    }

    public static String groovyNamedPropertyValue(NamedProperty property, String quote, Closure<String> bytesFromFile) {
        if (property.getValue().getServerValue() instanceof ExecutionProperty) {
            return DefaultGroovyMethods.toString((Object)property.getValue().getServerValue());
        }
        if (property.getValue().getServerValue() instanceof byte[]) {
            byte[] bytes = (byte[])ScriptBytecodeAdapter.castToType((Object)property.getValue().getServerValue(), byte[].class);
            public class _groovyNamedPropertyValue_closure12
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _groovyNamedPropertyValue_closure12(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return it;
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _groovyNamedPropertyValue_closure12.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"[", (CharSequence)DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect((Object)bytes, (Closure)new _groovyNamedPropertyValue_closure12(ContentUtils.class, ContentUtils.class)), (String)", ")), (CharSequence)"] as byte[]");
        }
        if (property.getValue().getServerValue() instanceof FromFileProperty) {
            FromFileProperty fromFileProperty = (FromFileProperty)ScriptBytecodeAdapter.castToType((Object)property.getValue().getServerValue(), FromFileProperty.class);
            if (fromFileProperty.isByte()) {
                return ShortTypeHandling.castToString((Object)bytesFromFile.call((Object)fromFileProperty));
            }
            public class _groovyNamedPropertyValue_closure13
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _groovyNamedPropertyValue_closure13(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return it;
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _groovyNamedPropertyValue_closure13.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"[", (CharSequence)DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect((Object)fromFileProperty.asBytes(), (Closure)new _groovyNamedPropertyValue_closure13(ContentUtils.class, ContentUtils.class)), (String)", ")), (CharSequence)"] as byte[]");
        }
        return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)quote, (CharSequence)StringEscapeUtils.escapeJava((String)DefaultGroovyMethods.toString((Object)property.getValue().getServerValue()))), (CharSequence)quote), (CharSequence)".bytes");
    }

    public static String javaNamedPropertyValue(NamedProperty property, String quote, Closure<String> bytesFromFile) {
        if (property.getValue().getServerValue() instanceof ExecutionProperty) {
            return DefaultGroovyMethods.toString((Object)property.getValue().getServerValue());
        }
        if (property.getValue().getServerValue() instanceof byte[]) {
            byte[] bytes = (byte[])ScriptBytecodeAdapter.castToType((Object)property.getValue().getServerValue(), byte[].class);
            public class _javaNamedPropertyValue_closure14
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _javaNamedPropertyValue_closure14(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return it;
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _javaNamedPropertyValue_closure14.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"new byte[] {", (CharSequence)DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect((Object)bytes, (Closure)new _javaNamedPropertyValue_closure14(ContentUtils.class, ContentUtils.class)), (String)", ")), (CharSequence)"}");
        }
        if (property.getValue().getServerValue() instanceof FromFileProperty) {
            FromFileProperty fromFileProperty = (FromFileProperty)ScriptBytecodeAdapter.castToType((Object)property.getValue().getServerValue(), FromFileProperty.class);
            if (fromFileProperty.isByte()) {
                return ShortTypeHandling.castToString((Object)bytesFromFile.call((Object)fromFileProperty));
            }
            public class _javaNamedPropertyValue_closure15
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _javaNamedPropertyValue_closure15(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return it;
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _javaNamedPropertyValue_closure15.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"new byte[] {", (CharSequence)DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect((Object)fromFileProperty.asBytes(), (Closure)new _javaNamedPropertyValue_closure15(ContentUtils.class, ContentUtils.class)), (String)", ")), (CharSequence)"}");
        }
        return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)quote, (CharSequence)StringEscapeUtils.escapeJava((String)DefaultGroovyMethods.toString((Object)property.getValue().getServerValue()))), (CharSequence)quote), (CharSequence)".getBytes()");
    }

    public static ContentType evaluateContentType(Headers contractHeaders, Object body) {
        ContentType contentType = ContentUtils.recognizeContentTypeFromHeader(contractHeaders);
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)ContentType.UNKNOWN), (Object)((Object)contentType))) {
            ContentType contentType2;
            contentType = contentType2 = ContentUtils.recognizeContentTypeFromContent(body);
        }
        return contentType;
    }

    public static /* synthetic */ Object access$0(ContentUtils $that) throws CloneNotSupportedException {
        return $that.clone();
    }

    protected static Object convertDslPropsToTemporaryRegexPatterns(Object parsedJson) {
        return ContentUtils.convertDslPropsToTemporaryRegexPatterns(parsedJson, MapConverter.JSON_PARSING_CLOSURE);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ContentUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Pattern pattern;
        Pattern pattern2;
        Pattern pattern3;
        Log log;
        ContentUtils.log = log = LogFactory.getLog(ContentUtils.class);
        public class __clinit__closure16
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure16(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return it instanceof DslProperty ? ((DslProperty)it).getClientValue() : it;
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        __clinit__closure16 __clinit__closure162 = new __clinit__closure16(ContentUtils.class, ContentUtils.class);
        GET_STUB_SIDE = __clinit__closure162;
        public class __clinit__closure17
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure17(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return it instanceof DslProperty ? ((DslProperty)it).getServerValue() : it;
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        __clinit__closure17 __clinit__closure172 = new __clinit__closure17(ContentUtils.class, ContentUtils.class);
        GET_TEST_SIDE = __clinit__closure172;
        TEMPORARY_PATTERN_HOLDER = pattern3 = Pattern.compile(".*REGEXP>>(.*)<<.*");
        TEMPORARY_EXECUTION_PATTERN_HOLDER = pattern2 = Pattern.compile("[\"]?EXECUTION>>(.*)<<[\"]?");
        TEMPORARY_OPTIONAL_PATTERN_HOLDER = pattern = Pattern.compile("OPTIONAL>>(.*)<<");
    }
}

