/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.noop;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierMessaging;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierObjectMapper;
import org.springframework.cloud.contract.verifier.messaging.noop.NoOpStubMessages;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureOrder(value=0x7FFFFFFF)
public class NoOpContractVerifierAutoConfiguration {
    @Autowired(required=false)
    ObjectMapper objectMapper;

    @Bean
    @ConditionalOnMissingBean
    public MessageVerifier<?> contractVerifierMessageExchange() {
        return new NoOpStubMessages();
    }

    @Bean
    @ConditionalOnMissingBean
    public ContractVerifierMessaging<?> contractVerifierMessaging(MessageVerifier<Object> exchange) {
        return new ContractVerifierMessaging<Object>(exchange);
    }

    @Bean
    @ConditionalOnMissingBean
    public ContractVerifierObjectMapper contractVerifierObjectMapper() {
        if (this.objectMapper != null) {
            return new ContractVerifierObjectMapper(this.objectMapper);
        }
        return new ContractVerifierObjectMapper();
    }
}

