/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.kafka;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.Consumer;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.cloud.contract.verifier.messaging.kafka.KafkaStubMessagesInitializer;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.test.EmbeddedKafkaBroker;
import org.springframework.kafka.test.utils.KafkaTestUtils;

class ContractVerifierKafkaStubMessagesInitializer
implements KafkaStubMessagesInitializer {
    private static final Log log = LogFactory.getLog(ContractVerifierKafkaStubMessagesInitializer.class);

    ContractVerifierKafkaStubMessagesInitializer() {
    }

    @Override
    public Map<String, Consumer> initialize(EmbeddedKafkaBroker broker, KafkaProperties kafkaProperties) {
        HashMap<String, Consumer> map = new HashMap<String, Consumer>();
        for (String topic : broker.getTopics()) {
            map.put(topic, this.prepareListener(broker, topic, kafkaProperties));
        }
        return map;
    }

    private Consumer prepareListener(EmbeddedKafkaBroker broker, String destination, KafkaProperties kafkaProperties) {
        Map consumerProperties = KafkaTestUtils.consumerProps((String)kafkaProperties.getConsumer().getGroupId(), (String)"false", (EmbeddedKafkaBroker)broker);
        consumerProperties.put("auto.offset.reset", "earliest");
        DefaultKafkaConsumerFactory consumerFactory = new DefaultKafkaConsumerFactory(consumerProperties);
        Consumer consumer = consumerFactory.createConsumer();
        broker.consumeFromAnEmbeddedTopic(consumer, destination);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Prepared consumer for destination [" + destination + "]"));
        }
        return consumer;
    }
}

