/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.verifier.converter.YamlContract;
import org.springframework.cloud.contract.verifier.converter.YamlContractConverter;
import org.springframework.cloud.contract.verifier.util.xml.DOMNamespaceContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ContractVerifierUtil {
    public static final String TEST_METHOD_PREFIX = "validate_";
    private static final Log LOG = LogFactory.getLog(ContractVerifierUtil.class);

    private ContractVerifierUtil() {
        throw new IllegalStateException("Can't instantiate utility class");
    }

    public static byte[] fileToBytes(Object testClass, String relativePath) {
        try {
            URL url = testClass.getClass().getResource(relativePath);
            if (url == null) {
                throw new FileNotFoundException(relativePath);
            }
            return Files.readAllBytes(Paths.get(url.toURI()));
        }
        catch (IOException | URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static String valueFromXPath(Document parsedXml, String path) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        Element documentElement = parsedXml.getDocumentElement();
        xPath.setNamespaceContext(new DOMNamespaceContext(documentElement));
        try {
            return xPath.evaluate(path, documentElement);
        }
        catch (XPathExpressionException exception) {
            LOG.error((Object)("Incorrect xpath provided: " + path), (Throwable)exception);
            throw new IllegalArgumentException();
        }
    }

    public static Node nodeFromXPath(Document parsedXml, String path) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        Element documentElement = parsedXml.getDocumentElement();
        xPath.setNamespaceContext(new DOMNamespaceContext(documentElement));
        try {
            return (Node)xPath.evaluate(path, documentElement, XPathConstants.NODE);
        }
        catch (XPathExpressionException exception) {
            LOG.error((Object)("Incorrect xpath provided: " + path), (Throwable)exception);
            throw new IllegalArgumentException();
        }
    }

    public static YamlContract contract(Object testClass, String relativePath) {
        String path = ContractVerifierUtil.fromRelativePath(relativePath);
        byte[] bytes = ContractVerifierUtil.fileToBytes(testClass, path);
        Object read = new YamlContractConverter().read(bytes);
        return read.isEmpty() ? null : (YamlContract)read.get(0);
    }

    static String fromRelativePath(String relativePath) {
        String path = relativePath;
        if (path.startsWith(TEST_METHOD_PREFIX)) {
            path = path.substring(TEST_METHOD_PREFIX.length());
        }
        if (path.endsWith("()")) {
            path = path.replace("()", "");
        }
        if (!path.endsWith(".yml")) {
            path = path + ".yml";
        }
        return path;
    }

    public static ContractVerifierMap map() {
        return new ContractVerifierMap();
    }

    public static class ContractVerifierMap
    implements Map<Object, Object> {
        private final Map<Object, Object> delegate = new HashMap<Object, Object>();

        public ContractVerifierMap entry(String key, Object value) {
            this.put(key, value);
            return this;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.delegate.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.delegate.containsValue(value);
        }

        @Override
        public Object get(Object key) {
            return this.delegate.get(key);
        }

        @Override
        public Object put(Object key, Object value) {
            return this.delegate.put(key, value);
        }

        @Override
        public Object remove(Object key) {
            return this.delegate.remove(key);
        }

        @Override
        public void putAll(Map<? extends Object, ?> m) {
            this.delegate.putAll(m);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public Set<Object> keySet() {
            return this.delegate.keySet();
        }

        @Override
        public Collection<Object> values() {
            return this.delegate.values();
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            return this.delegate.entrySet();
        }

        @Override
        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }
    }
}

