/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Arrays;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.Imports;
import org.springframework.cloud.contract.verifier.config.TestMode;

class MockMvcRestAssuredStaticImports
implements Imports {
    private final BlockBuilder blockBuilder;
    private final GeneratedClassMetaData generatedClassMetaData;
    private static final String[] REST_ASSURED_3_IMPORTS = new String[]{"io.restassured.module.mockmvc.RestAssuredMockMvc.*"};

    MockMvcRestAssuredStaticImports(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = generatedClassMetaData;
    }

    @Override
    public Imports call() {
        Arrays.stream(REST_ASSURED_3_IMPORTS).forEach(s -> this.blockBuilder.addLineWithEnding("import static " + s));
        return this;
    }

    @Override
    public boolean accept() {
        return this.generatedClassMetaData.configProperties.getTestMode() == TestMode.MOCKMVC && this.generatedClassMetaData.isAnyHttp();
    }
}

