/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.contract.verifier.util.NamesUtil;

class FileSaver {
    private static final Logger log = LoggerFactory.getLogger(FileSaver.class);
    private final File targetDirectory;
    private final String fileExtension;

    FileSaver(File targetDirectory, String fileExtension) {
        this.targetDirectory = targetDirectory;
        this.fileExtension = fileExtension;
    }

    public void saveClassFile(Path classPath, byte[] classBytes) {
        log.info("Creating new class file [{}]", (Object)classPath);
        try {
            Files.write(classPath, classBytes, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Path pathToClass(Path testBaseDir, String fileName) {
        return Paths.get(testBaseDir.toString(), NamesUtil.capitalize(fileName) + this.fileExtension).toAbsolutePath();
    }

    protected Path generateTestBaseDir(String basePackageClass, String includedDirectoryRelativePath) {
        Path testBaseDir = Paths.get(this.targetDirectory.getAbsolutePath(), NamesUtil.packageToDirectory(basePackageClass), NamesUtil.beforeLast(includedDirectoryRelativePath, File.separator));
        try {
            Files.createDirectories(testBaseDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return testBaseDir;
    }
}

