/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import org.springframework.cloud.contract.spec.internal.Header;
import org.springframework.cloud.contract.spec.internal.Input;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.Given;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;
import org.springframework.cloud.contract.verifier.util.MapConverter;

class MessagingHeadersGiven
implements Given,
MethodVisitor<Given> {
    private final BlockBuilder blockBuilder;

    MessagingHeadersGiven(BlockBuilder blockBuilder) {
        this.blockBuilder = blockBuilder;
    }

    @Override
    public MethodVisitor<Given> apply(SingleContractMetadata metadata) {
        Input inputMessage = metadata.getContract().getInput();
        this.blockBuilder.startBlock().addIndented(", headers()").startBlock();
        inputMessage.getMessageHeaders().executeForEachHeader(header -> this.blockBuilder.addEmptyLine().addIndented(this.getHeaderString((Header)header)));
        this.blockBuilder.endBlock();
        return this;
    }

    private String getHeaderString(Header header) {
        return ".header(" + this.getTestSideValue(header.getName()) + ", " + this.getTestSideValue(header.getServerValue()) + ")";
    }

    private String getTestSideValue(Object object) {
        return '\"' + MapConverter.getTestSideValues(object).toString() + '\"';
    }

    @Override
    public boolean accept(SingleContractMetadata metadata) {
        return metadata.getContract().getInput().getMessageHeaders() != null;
    }
}

