/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.stream;

import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.verifier.converter.YamlContract;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifierReceiver;
import org.springframework.cloud.contract.verifier.messaging.stream.DefaultChannels;
import org.springframework.cloud.contract.verifier.messaging.stream.DestinationResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.integration.channel.QueueChannel;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.PollableChannel;
import org.springframework.messaging.SubscribableChannel;

class StreamPollableChannelMessageReceiver
implements MessageVerifierReceiver<Message<?>> {
    private static final Log log = LogFactory.getLog(StreamPollableChannelMessageReceiver.class);
    private final ApplicationContext context;
    private final DestinationResolver destinationResolver;
    private final PollableChannel messageChannel;

    StreamPollableChannelMessageReceiver(ApplicationContext context) {
        this.context = context;
        this.destinationResolver = new DestinationResolver(context);
        this.messageChannel = new QueueChannel(1);
    }

    @Override
    public Message<?> receive(String destination, long timeout, TimeUnit timeUnit, YamlContract contract) {
        MessageHandler handler = arg_0 -> ((PollableChannel)this.messageChannel).send(arg_0);
        MessageChannel channel = null;
        try {
            channel = (MessageChannel)this.context.getBean(this.destinationResolver.resolvedDestination(destination, DefaultChannels.INPUT), MessageChannel.class);
            if (channel instanceof SubscribableChannel) {
                ((SubscribableChannel)channel).subscribe(handler);
                Message message = this.messageChannel.receive(timeUnit.toMillis(timeout));
                return message;
            }
            if (channel instanceof PollableChannel) {
                Message message = ((PollableChannel)channel).receive(timeUnit.toMillis(timeout));
                return message;
            }
            try {
                throw new IllegalStateException("Unsupported channel type");
            }
            catch (Exception e) {
                log.error((Object)("Exception occurred while trying to read a message from  a channel with name [" + destination + "]"), (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
        finally {
            if (channel instanceof SubscribableChannel) {
                ((SubscribableChannel)channel).unsubscribe(handler);
            }
        }
    }

    @Override
    public Message<?> receive(String destination, YamlContract contract) {
        return this.receive(destination, 5L, TimeUnit.SECONDS, contract);
    }
}

