/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.cloud.contract.verifier.builder.ComparisonBuilder;
import org.springframework.cloud.contract.verifier.builder.JaxRsBodyParser;
import org.springframework.cloud.contract.verifier.builder.SpockMessagingBodyParser;
import org.springframework.cloud.contract.verifier.builder.SpockRestAssuredBodyParser;

interface GroovyComparisonBuilder
extends ComparisonBuilder {
    public static final ComparisonBuilder SPOCK_HTTP_INSTANCE = () -> SpockRestAssuredBodyParser.INSTANCE;
    public static final ComparisonBuilder JAXRS_HTTP_INSTANCE = () -> JaxRsBodyParser.INSTANCE;
    public static final ComparisonBuilder SPOCK_MESSAGING_INSTANCE = () -> SpockMessagingBodyParser.INSTANCE;

    @Override
    default public String assertThat(String object) {
        return object;
    }

    @Override
    default public String isEqualToUnquoted(String unquoted) {
        return " == " + unquoted;
    }

    @Override
    default public String isEqualTo(Number number) {
        String numberString = number instanceof Long ? number.toString() + "L" : number.toString();
        return " == " + numberString;
    }

    @Override
    default public String matches(String pattern) {
        return this.matchesEscaped(this.bodyParser().quotedShortText(pattern));
    }

    @Override
    default public String matches(Pattern pattern) {
        String escapedPattern = StringEscapeUtils.escapeJava((String)pattern.pattern());
        return this.matchesEscaped(escapedPattern);
    }

    @Override
    default public String matchesEscaped(String pattern) {
        return " ==~ java.util.regex.Pattern.compile(" + this.bodyParser().quotedEscapedShortText(pattern) + ")";
    }

    @Override
    default public String isNotNull() {
        return " != null";
    }
}

