/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.util.xml;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.springframework.cloud.contract.verifier.util.xml.FieldAssertion;
import org.springframework.cloud.contract.verifier.util.xml.ReadyToCheckAsserter;
import org.springframework.cloud.contract.verifier.util.xml.XmlArrayVerifiable;
import org.springframework.cloud.contract.verifier.util.xml.XmlAsserter;
import org.springframework.cloud.contract.verifier.util.xml.XmlAsserterConfiguration;
import org.springframework.cloud.contract.verifier.util.xml.XmlCachedObjects;
import org.springframework.cloud.contract.verifier.util.xml.XmlVerifiable;

class ArrayValueAssertion
extends FieldAssertion
implements XmlArrayVerifiable {
    private final boolean checkingPrimitiveType;

    ArrayValueAssertion(XmlCachedObjects cachedObjects, LinkedList<String> xPathBuffer, LinkedList<String> specialCaseXPathBuffer, Object arrayName, XmlAsserterConfiguration xmlAsserterConfiguration) {
        super(cachedObjects, xPathBuffer, specialCaseXPathBuffer, arrayName, xmlAsserterConfiguration);
        this.checkingPrimitiveType = true;
    }

    private ArrayValueAssertion(XmlCachedObjects cachedObjects, LinkedList<String> xPathBuffer, LinkedList<String> specialCaseXPathBuffer, Object arrayName, XmlAsserterConfiguration xmlAsserterConfiguration, boolean checkingPrimitiveType) {
        super(cachedObjects, xPathBuffer, specialCaseXPathBuffer, arrayName, xmlAsserterConfiguration);
        this.checkingPrimitiveType = checkingPrimitiveType;
    }

    private ArrayValueAssertion(XmlAsserter asserter, boolean checkingPrimitiveType) {
        super(asserter);
        this.checkingPrimitiveType = checkingPrimitiveType;
    }

    @Override
    public XmlArrayVerifiable contains(String value) {
        return new ArrayValueAssertion(this.cachedObjects, this.xPathBuffer, this.specialCaseXPathBuffer, value, this.xmlAsserterConfiguration, false);
    }

    @Override
    public XmlArrayVerifiable hasSize(int size) {
        String xPath = "count(" + this.createXPathString() + ")";
        ArrayValueAssertion verifiable = new ArrayValueAssertion(this, this.checkingPrimitiveType);
        verifiable.specialCaseXPathBuffer.clear();
        verifiable.specialCaseXPathBuffer.add(xPath);
        String xPathString = verifiable.createSpecialCaseXPathString();
        ResultSequence sequence = verifiable.resultSequence(xPathString);
        Iterator iterator = sequence.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException("Parsed XML [" + this.cachedObjects.xmlAsString + "] doesn't match the XPath <" + xPathString + ">");
        }
        int retrievedSize = Integer.valueOf(((Item)iterator.next()).getStringValue());
        if (retrievedSize != size) {
            throw new IllegalStateException("Parsed XML [" + this.cachedObjects.xmlAsString + "] has size [" + retrievedSize + "] and not [" + size + "] for XPath <" + xPathString + "> ");
        }
        return verifiable;
    }

    @Override
    public FieldAssertion node(String value) {
        FieldAssertion assertion = super.node(value);
        return new ArrayValueAssertion(assertion, false);
    }

    @Override
    public FieldAssertion nodeWithDefaultNamespace(String value, String defaultNamespace) {
        FieldAssertion assertion = super.nodeWithDefaultNamespace(value, defaultNamespace);
        return new ArrayValueAssertion(assertion, false);
    }

    @Override
    public FieldAssertion node(String ... nodeNames) {
        FieldAssertion assertion = super.node(nodeNames);
        return new ArrayValueAssertion(assertion, false);
    }

    @Override
    protected void removeLastFieldElement(XmlAsserter readyToCheck) {
        readyToCheck.xPathBuffer.removeLast();
    }

    @Override
    public XmlVerifiable isEqualTo(String value) {
        if (!this.checkingPrimitiveType) {
            return super.isEqualTo(value);
        }
        return this.equalityOnAPrimitive("[text()=" + ArrayValueAssertion.escapeText(value) + "]");
    }

    @Override
    public XmlVerifiable isEqualTo(Number value) {
        if (!this.checkingPrimitiveType) {
            return super.isEqualTo(value);
        }
        return this.equalityOnAPrimitive("[number()=" + String.valueOf(value) + "]");
    }

    private XmlVerifiable equalityOnAPrimitive(String xPath) {
        ReadyToCheckAsserter readyToCheck = new ReadyToCheckAsserter(this.cachedObjects, this.xPathBuffer, this.fieldName, this.xmlAsserterConfiguration);
        readyToCheck.xPathBuffer.removeLast();
        readyToCheck.xPathBuffer.offer(xPath);
        readyToCheck.checkBufferedXPathString();
        return readyToCheck;
    }

    @Override
    public XmlVerifiable matches(String value) {
        if (!this.checkingPrimitiveType) {
            return super.matches(value);
        }
        return this.equalityOnAPrimitive("[matches(text(), " + ArrayValueAssertion.escapeText(ArrayValueAssertion.escapeRegex(value)) + ")]");
    }

    @Override
    public XmlVerifiable isEqualTo(Boolean value) {
        if (!this.checkingPrimitiveType) {
            return super.isEqualTo(value);
        }
        return this.isEqualTo(String.valueOf(value));
    }

    @Override
    public boolean isAssertingAValueInArray() {
        return true;
    }
}

