/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Iterator;
import java.util.regex.Pattern;
import org.springframework.cloud.contract.spec.internal.Cookie;
import org.springframework.cloud.contract.spec.internal.Cookies;
import org.springframework.cloud.contract.spec.internal.ExecutionProperty;
import org.springframework.cloud.contract.spec.internal.NotToEscapePattern;
import org.springframework.cloud.contract.spec.internal.Response;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.ComparisonBuilder;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;
import org.springframework.cloud.contract.verifier.util.MapConverter;

interface CookieElementProcessor {
    public ComparisonBuilder comparisonBuilder();

    default public void processCookies(SingleContractMetadata metadata) {
        Response response = metadata.getContract().getResponse();
        Cookies cookies = response.getCookies();
        Iterator iterator = cookies.getEntries().iterator();
        while (iterator.hasNext()) {
            Cookie cookie = (Cookie)iterator.next();
            String text = this.processCookieElement(cookie.getKey(), cookie.getServerValue() instanceof NotToEscapePattern ? cookie.getServerValue() : MapConverter.getTestSideValues(cookie.getServerValue()));
            if (iterator.hasNext()) {
                this.blockBuilder().addLine(text).addEndingIfNotPresent();
                continue;
            }
            this.blockBuilder().addIndented(text).addEndingIfNotPresent();
        }
    }

    public BlockBuilder blockBuilder();

    default public String processCookieElement(String property, Object value) {
        if (value instanceof NotToEscapePattern) {
            this.verifyCookieNotNull(property);
            return this.comparisonBuilder().assertThat(this.cookieValue(property)) + this.comparisonBuilder().matches(((Pattern)((NotToEscapePattern)value).getServerValue()).pattern().replace("\\", "\\\\"));
        }
        if (value instanceof String || value instanceof Pattern) {
            this.verifyCookieNotNull(property);
            return this.comparisonBuilder().assertThat(this.cookieValue(property), value);
        }
        if (value instanceof Number) {
            this.verifyCookieNotNull(property);
            return this.comparisonBuilder().assertThat(this.cookieValue(property), value);
        }
        if (value instanceof ExecutionProperty) {
            this.verifyCookieNotNull(property);
            return ((ExecutionProperty)value).insertValue(this.cookieValue(property));
        }
        return this.processCookieElement(property, value.toString());
    }

    default public void verifyCookieNotNull(String key) {
        this.blockBuilder().addLineWithEnding(this.comparisonBuilder().assertThatIsNotNull(this.cookieKey(key)));
    }

    public String cookieKey(String var1);

    default public String cookieValue(String key) {
        return this.cookieKey(key);
    }
}

