/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.CustomModeImports;
import org.springframework.cloud.contract.verifier.builder.CustomModeStaticImports;
import org.springframework.cloud.contract.verifier.builder.DefaultImports;
import org.springframework.cloud.contract.verifier.builder.DefaultJsonStaticImports;
import org.springframework.cloud.contract.verifier.builder.DefaultStaticImports;
import org.springframework.cloud.contract.verifier.builder.ExplicitRestAssuredImports;
import org.springframework.cloud.contract.verifier.builder.ExplicitRestAssuredStaticImports;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.GeneratedTestClassBuilder;
import org.springframework.cloud.contract.verifier.builder.Imports;
import org.springframework.cloud.contract.verifier.builder.JUnit4IgnoreImports;
import org.springframework.cloud.contract.verifier.builder.JUnit4Imports;
import org.springframework.cloud.contract.verifier.builder.JUnit4OrderImports;
import org.springframework.cloud.contract.verifier.builder.JUnit5IgnoreImports;
import org.springframework.cloud.contract.verifier.builder.JUnit5Imports;
import org.springframework.cloud.contract.verifier.builder.JUnit5OrderImports;
import org.springframework.cloud.contract.verifier.builder.JaxRsImports;
import org.springframework.cloud.contract.verifier.builder.JaxRsStaticImports;
import org.springframework.cloud.contract.verifier.builder.JsonPathImports;
import org.springframework.cloud.contract.verifier.builder.MessagingImports;
import org.springframework.cloud.contract.verifier.builder.MessagingStaticImports;
import org.springframework.cloud.contract.verifier.builder.MockMvcRestAssuredImports;
import org.springframework.cloud.contract.verifier.builder.MockMvcRestAssuredStaticImports;
import org.springframework.cloud.contract.verifier.builder.SpockIgnoreImports;
import org.springframework.cloud.contract.verifier.builder.SpockImports;
import org.springframework.cloud.contract.verifier.builder.SpockOrderImports;
import org.springframework.cloud.contract.verifier.builder.TestNGImports;
import org.springframework.cloud.contract.verifier.builder.UserImports;
import org.springframework.cloud.contract.verifier.builder.UserStaticImports;
import org.springframework.cloud.contract.verifier.builder.WebTestClientRestAssured3StaticImports;
import org.springframework.cloud.contract.verifier.builder.WebTestClientRestAssuredImports;
import org.springframework.cloud.contract.verifier.builder.XmlImports;

class ImportsBuilder {
    private final GeneratedTestClassBuilder parentBuilder;
    private final BlockBuilder builder;
    private final GeneratedClassMetaData metaData;

    ImportsBuilder(GeneratedTestClassBuilder generatedTestClassBuilder) {
        this.parentBuilder = generatedTestClassBuilder;
        this.builder = generatedTestClassBuilder.blockBuilder;
        this.metaData = generatedTestClassBuilder.generatedClassMetaData;
    }

    ImportsBuilder defaultImports() {
        this.parentBuilder.imports((Imports)new DefaultImports(this.builder, this.metaData));
        this.parentBuilder.staticImports((Imports)new DefaultStaticImports(this.builder));
        return this;
    }

    ImportsBuilder userImports() {
        this.parentBuilder.imports((Imports)new UserImports(this.builder, this.metaData));
        this.parentBuilder.staticImports((Imports)new UserStaticImports(this.builder, this.metaData));
        return this;
    }

    ImportsBuilder customMode() {
        this.parentBuilder.imports((Imports)new CustomModeImports(this.builder, this.metaData));
        this.parentBuilder.staticImports((Imports)new CustomModeStaticImports(this.builder, this.metaData));
        return this;
    }

    ImportsBuilder json() {
        this.parentBuilder.imports((Imports)new JsonPathImports(this.builder, this.metaData));
        this.parentBuilder.staticImports((Imports)new DefaultJsonStaticImports(this.builder, this.metaData));
        return this;
    }

    ImportsBuilder xml() {
        this.parentBuilder.imports((Imports)new XmlImports(this.builder, this.metaData));
        return this;
    }

    ImportsBuilder jUnit4() {
        this.parentBuilder.imports(new JUnit4Imports(this.builder, this.metaData), new JUnit4IgnoreImports(this.builder, this.metaData), new JUnit4OrderImports(this.builder, this.metaData));
        return this;
    }

    ImportsBuilder jUnit5() {
        this.parentBuilder.imports(new JUnit5Imports(this.builder, this.metaData), new JUnit5IgnoreImports(this.builder, this.metaData), new JUnit5OrderImports(this.builder, this.metaData));
        return this;
    }

    ImportsBuilder testNG() {
        this.parentBuilder.imports((Imports)new TestNGImports(this.builder, this.metaData));
        return this;
    }

    ImportsBuilder spock() {
        this.parentBuilder.imports(new SpockImports(this.builder, this.metaData), new SpockIgnoreImports(this.builder, this.metaData), new SpockOrderImports(this.builder, this.metaData));
        return this;
    }

    ImportsBuilder messaging() {
        this.parentBuilder.imports((Imports)new MessagingImports(this.builder, this.metaData));
        this.parentBuilder.staticImports((Imports)new MessagingStaticImports(this.builder, this.metaData));
        return this;
    }

    ImportsBuilder restAssured() {
        this.parentBuilder.imports(new MockMvcRestAssuredImports(this.builder, this.metaData), new ExplicitRestAssuredImports(this.builder, this.metaData), new WebTestClientRestAssuredImports(this.builder, this.metaData));
        this.parentBuilder.staticImports(new MockMvcRestAssuredStaticImports(this.builder, this.metaData), new ExplicitRestAssuredStaticImports(this.builder, this.metaData), new WebTestClientRestAssured3StaticImports(this.builder, this.metaData));
        return this;
    }

    ImportsBuilder jaxRs() {
        this.parentBuilder.imports((Imports)new JaxRsImports(this.builder, this.metaData));
        this.parentBuilder.staticImports((Imports)new JaxRsStaticImports(this.builder, this.metaData));
        return this;
    }

    GeneratedTestClassBuilder build() {
        return this.parentBuilder;
    }
}

