/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import org.apache.commons.lang3.StringUtils;

public class BlockBuilder {
    private final StringBuilder builder;
    private final String spacer;
    private int indents;
    private String lineEnding = "";
    private String labelPrefix = "";

    public BlockBuilder(String spacer) {
        this.spacer = spacer;
        this.builder = new StringBuilder();
    }

    public BlockBuilder setupLineEnding(String lineEnding) {
        this.lineEnding = lineEnding;
        return this;
    }

    public BlockBuilder setupLabelPrefix(String labelPrefix) {
        this.labelPrefix = labelPrefix;
        return this;
    }

    public String getLineEnding() {
        return this.lineEnding;
    }

    public BlockBuilder appendWithLabelPrefix(String label) {
        return this.append(this.labelPrefix).append(label);
    }

    public BlockBuilder startBlock() {
        ++this.indents;
        return this;
    }

    public BlockBuilder endBlock() {
        --this.indents;
        return this;
    }

    public BlockBuilder indent() {
        this.startBlock().startBlock();
        return this;
    }

    public BlockBuilder unindent() {
        this.endBlock().endBlock();
        return this;
    }

    public BlockBuilder addLine(String line) {
        return this.addIndented(line).append("\n");
    }

    public BlockBuilder addIndented(String line) {
        return this.addIndentation().append(line);
    }

    public BlockBuilder addIndented(Runnable runnable) {
        this.addIndentation();
        runnable.run();
        return this;
    }

    public BlockBuilder addLineWithEnding(String line) {
        this.addIndentation();
        this.append(line).addEndingIfNotPresent().addEmptyLine();
        return this;
    }

    public BlockBuilder addEndingIfNotPresent() {
        this.addAtTheEnd(this.lineEnding);
        return this;
    }

    public BlockBuilder addEmptyLine() {
        this.builder.append("\n");
        return this;
    }

    public BlockBuilder appendWithSpace(String text) {
        return this.addAtTheEnd(" ").append(text);
    }

    public BlockBuilder appendWithSpace(Runnable runnable) {
        this.addAtTheEnd(" ");
        runnable.run();
        return this;
    }

    public BlockBuilder append(Runnable runnable) {
        runnable.run();
        return this;
    }

    public BlockBuilder append(String string) {
        this.builder.append(string);
        return this;
    }

    public BlockBuilder addIndentation() {
        for (int i = 0; i < this.indents; ++i) {
            this.builder.append(this.spacer);
        }
        return this;
    }

    BlockBuilder inBraces(Runnable runnable) {
        this.builder.append("{\n");
        this.startBlock();
        runnable.run();
        this.endBlock();
        this.addAtTheEnd("\n");
        this.addLine("}");
        return this;
    }

    public boolean endsWith(String text) {
        return this.builder.toString().endsWith(text);
    }

    public BlockBuilder addAtTheEndIfEndsWithAChar(String toAdd) {
        char lastChar = this.builder.charAt(this.builder.length() - 1);
        if (Character.isLetter(lastChar)) {
            this.builder.append(toAdd);
        }
        return this;
    }

    public BlockBuilder addAtTheEnd(String toAdd) {
        String lastChar = String.valueOf(this.builder.charAt(this.builder.length() - 1));
        String secondLastChar = this.builder.length() >= 2 ? String.valueOf(this.builder.charAt(this.builder.length() - 2)) : "";
        boolean isEndWithNewLine = this.endsWithNewLine(lastChar);
        boolean lastCharSpecial = this.aSpecialSign(lastChar, toAdd);
        boolean secondLastCharSpecial = this.aSpecialSign(secondLastChar, toAdd);
        boolean lineEndingToAdd = toAdd.equals(this.lineEnding);
        if (lastChar.equals(toAdd)) {
            return this;
        }
        if (!isEndWithNewLine && lastCharSpecial && lineEndingToAdd) {
            return this;
        }
        if (isEndWithNewLine && secondLastCharSpecial) {
            return this;
        }
        if (isEndWithNewLine && !secondLastCharSpecial) {
            this.builder.replace(this.builder.length() - 1, this.builder.length(), toAdd);
            this.builder.append("\n");
        } else {
            this.builder.append(toAdd);
        }
        return this;
    }

    private boolean endsWithNewLine(String character) {
        return character.equals("\n");
    }

    private boolean aSpecialSign(String character, String toAdd) {
        if (StringUtils.isEmpty((CharSequence)character)) {
            return false;
        }
        return character.equals("{") || character.equals(this.spacer) && toAdd.equals(this.spacer) || character.equals(this.spacer) && toAdd.equals(" ") || character.equals(toAdd) || this.endsWithNewLine(character) && StringUtils.equalsAny((CharSequence)toAdd, (CharSequence[])new CharSequence[]{"\n", " ", this.lineEnding});
    }

    public BlockBuilder updateContents(String contents) {
        this.builder.replace(0, this.builder.length(), contents);
        return this;
    }

    public String toString() {
        return this.builder.toString();
    }
}

