/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import org.springframework.cloud.contract.spec.internal.Header;
import org.springframework.cloud.contract.spec.internal.Request;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.JaxRsAcceptor;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.builder.QueryParamsResolver;
import org.springframework.cloud.contract.verifier.builder.When;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;
import org.springframework.cloud.contract.verifier.util.MapConverter;
import org.springframework.util.StringUtils;

class JaxRsRequestWhen
implements When,
JaxRsAcceptor,
QueryParamsResolver {
    private final BlockBuilder blockBuilder;
    private final GeneratedClassMetaData generatedClassMetaData;

    JaxRsRequestWhen(BlockBuilder blockBuilder, GeneratedClassMetaData metaData) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = metaData;
    }

    @Override
    public MethodVisitor<When> apply(SingleContractMetadata metadata) {
        this.appendRequestWithRequiredResponseContentType(metadata.getContract().getRequest());
        return this;
    }

    void appendRequestWithRequiredResponseContentType(Request request) {
        String acceptHeader = this.getHeader(request, "Accept");
        if (StringUtils.hasText((String)acceptHeader)) {
            this.blockBuilder.addIndented(".request(\"" + acceptHeader + "\")");
        } else {
            this.blockBuilder.addIndented(".request()");
        }
    }

    private String getHeader(Request request, String name) {
        if (request.getHeaders() == null || request.getHeaders().getEntries() == null) {
            return "";
        }
        Header foundHeader = request.getHeaders().getEntries().stream().filter(header -> name.equals(header.getName())).findFirst().orElse(null);
        if (foundHeader == null) {
            return "";
        }
        return MapConverter.getTestSideValuesForNonBody(foundHeader.getServerValue()).toString();
    }

    @Override
    public boolean accept(SingleContractMetadata metadata) {
        return this.acceptType(this.generatedClassMetaData, metadata);
    }
}

