/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.SocketUtils;

@Order(value=0x7FFFFFFF)
public class WireMockApplicationListener
implements ApplicationListener<ApplicationPreparedEvent> {
    public void onApplicationEvent(ApplicationPreparedEvent event) {
        this.registerPort(event.getApplicationContext().getEnvironment());
    }

    private void registerPort(ConfigurableEnvironment environment) {
        Map source;
        MutablePropertySources propertySources;
        if ((Integer)environment.getProperty("wiremock.server.port", Integer.class, (Object)0) == 0) {
            propertySources = environment.getPropertySources();
            if (!propertySources.contains("wiremock")) {
                propertySources.addFirst((PropertySource)new MapPropertySource("wiremock", new HashMap()));
            }
            source = (Map)((MapPropertySource)propertySources.get("wiremock")).getSource();
            source.put("wiremock.server.port", SocketUtils.findAvailableTcpPort((int)10000, (int)12500));
        }
        if ((Integer)environment.getProperty("wiremock.server.https-port", Integer.class, (Object)0) == 0) {
            propertySources = environment.getPropertySources();
            if (!propertySources.contains("wiremock")) {
                propertySources.addFirst((PropertySource)new MapPropertySource("wiremock", new HashMap()));
            }
            source = (Map)((MapPropertySource)propertySources.get("wiremock")).getSource();
            source.put("wiremock.server.https-port", SocketUtils.findAvailableTcpPort((int)12500, (int)15000));
        }
    }
}

