/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock.restdocs;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.http.Request;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.cloud.contract.wiremock.restdocs.WireMockHttpServletRequestAdapter;
import org.springframework.cloud.contract.wiremock.restdocs.WireMockVerifyHelper;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultHandler;

public class ContractResultHandler
extends WireMockVerifyHelper<MvcResult, ContractResultHandler>
implements ResultHandler {
    static final String ATTRIBUTE_NAME_CONFIGURATION = "org.springframework.restdocs.configuration";

    public void handle(MvcResult result) throws Exception {
        this.configure(result);
    }

    @Override
    protected ResponseDefinitionBuilder getResponseDefinition(MvcResult result) {
        MockHttpServletResponse response = result.getResponse();
        try {
            ResponseDefinitionBuilder definition = ResponseDefinitionBuilder.responseDefinition().withBody(response.getContentAsString()).withStatus(response.getStatus());
            this.addResponseHeaders(definition, response);
            return definition;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Cannot create response body", e);
        }
    }

    private void addResponseHeaders(ResponseDefinitionBuilder definition, MockHttpServletResponse input) {
        for (String name : input.getHeaderNames()) {
            definition.withHeader(name, new String[]{input.getHeader(name)});
        }
    }

    @Override
    protected Map<String, Object> getConfiguration(MvcResult result) {
        HashMap map = (HashMap)result.getRequest().getAttribute(ATTRIBUTE_NAME_CONFIGURATION);
        if (map == null) {
            map = new HashMap();
            result.getRequest().setAttribute(ATTRIBUTE_NAME_CONFIGURATION, map);
        }
        return map;
    }

    @Override
    protected Request getWireMockRequest(MvcResult result) {
        return new WireMockHttpServletRequestAdapter((HttpServletRequest)result.getRequest());
    }

    @Override
    protected MediaType getContentType(MvcResult result) {
        return MediaType.valueOf((String)result.getRequest().getContentType());
    }

    @Override
    protected byte[] getRequestBodyContent(MvcResult result) {
        byte[] body = new WireMockHttpServletRequestAdapter((HttpServletRequest)result.getRequest()).getBody();
        return body != null ? body : new byte[]{};
    }
}

