/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.HashSet;
import java.util.List;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.TaskExpansionStrategy;
import org.springframework.cloud.dataflow.configuration.metadata.ApplicationConfigurationMetadataResolver;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.TaskDefinition;
import org.springframework.cloud.dataflow.registry.AppRegistration;
import org.springframework.cloud.dataflow.registry.AppRegistry;
import org.springframework.core.io.Resource;

class AddAppOptionsTaskExpansionStrategy
implements TaskExpansionStrategy {
    private final AppRegistry appRegistry;
    private final ApplicationConfigurationMetadataResolver metadataResolver;

    public AddAppOptionsTaskExpansionStrategy(AppRegistry appRegistry, ApplicationConfigurationMetadataResolver metadataResolver) {
        this.appRegistry = appRegistry;
        this.metadataResolver = metadataResolver;
    }

    @Override
    public boolean addProposals(String text, TaskDefinition taskDefinition, int detailLevel, List<CompletionProposal> collector) {
        String appName = taskDefinition.getRegisteredAppName();
        AppRegistration appRegistration = this.appRegistry.find(appName, ApplicationType.task);
        if (appRegistration == null) {
            return false;
        }
        HashSet alreadyPresentOptions = new HashSet(taskDefinition.getProperties().keySet());
        Resource jarFile = appRegistration.getResource();
        CompletionProposal.Factory proposals = CompletionProposal.expanding(text);
        for (ConfigurationMetadataProperty property : this.metadataResolver.listProperties(jarFile)) {
            if (alreadyPresentOptions.contains(property.getName())) continue;
            collector.add(proposals.withSeparateTokens("--" + property.getName() + "=", property.getShortDescription()));
        }
        if (detailLevel > 1) {
            for (ConfigurationMetadataProperty property : this.metadataResolver.listProperties(jarFile, true)) {
                if (alreadyPresentOptions.contains(property.getId())) continue;
                collector.add(proposals.withSeparateTokens("--" + property.getId() + "=", property.getShortDescription()));
            }
        }
        return false;
    }
}

