/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.HashSet;
import java.util.List;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.StacktraceFingerprintingTaskRecoveryStrategy;
import org.springframework.cloud.dataflow.configuration.metadata.ApplicationConfigurationMetadataResolver;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.TaskDefinition;
import org.springframework.cloud.dataflow.core.dsl.CheckPointedParseException;
import org.springframework.cloud.dataflow.registry.AppRegistration;
import org.springframework.cloud.dataflow.registry.AppRegistry;
import org.springframework.core.io.Resource;

class ConfigurationPropertyNameAfterDashDashTaskRecoveryStrategy
extends StacktraceFingerprintingTaskRecoveryStrategy<CheckPointedParseException> {
    private final AppRegistry appRegistry;
    private final ApplicationConfigurationMetadataResolver metadataResolver;

    ConfigurationPropertyNameAfterDashDashTaskRecoveryStrategy(AppRegistry appRegistry, ApplicationConfigurationMetadataResolver metadataResolver) {
        super(CheckPointedParseException.class, "file --");
        this.appRegistry = appRegistry;
        this.metadataResolver = metadataResolver;
    }

    @Override
    public void addProposals(String dsl, CheckPointedParseException exception, int detailLevel, List<CompletionProposal> collector) {
        String safe = exception.getExpressionStringUntilCheckpoint();
        TaskDefinition taskDefinition = new TaskDefinition("__dummy", safe);
        String appName = taskDefinition.getRegisteredAppName();
        AppRegistration appRegistration = this.appRegistry.find(appName, ApplicationType.task);
        if (appRegistration == null) {
            return;
        }
        HashSet alreadyPresentOptions = new HashSet(taskDefinition.getProperties().keySet());
        Resource jarFile = appRegistration.getResource();
        CompletionProposal.Factory proposals = CompletionProposal.expanding(dsl);
        for (ConfigurationMetadataProperty property : this.metadataResolver.listProperties(jarFile)) {
            if (alreadyPresentOptions.contains(property.getName())) continue;
            collector.add(proposals.withSuffix(property.getName() + "=", property.getShortDescription()));
        }
        if (detailLevel > 1) {
            for (ConfigurationMetadataProperty property : this.metadataResolver.listProperties(jarFile, true)) {
                if (alreadyPresentOptions.contains(property.getId())) continue;
                collector.add(proposals.withSuffix(property.getId() + "=", property.getShortDescription()));
            }
        }
    }
}

