/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.io.IOException;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.configurationmetadata.ValueHint;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.CompletionUtils;
import org.springframework.cloud.dataflow.completion.TaskExpansionStrategy;
import org.springframework.cloud.dataflow.completion.ValueHintProvider;
import org.springframework.cloud.dataflow.configuration.metadata.ApplicationConfigurationMetadataResolver;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.TaskDefinition;
import org.springframework.cloud.dataflow.core.dsl.CheckPointedParseException;
import org.springframework.cloud.dataflow.core.dsl.Token;
import org.springframework.cloud.dataflow.core.dsl.TokenKind;
import org.springframework.cloud.dataflow.registry.AppRegistration;
import org.springframework.cloud.dataflow.registry.AppRegistry;
import org.springframework.core.io.Resource;

public class ConfigurationPropertyValueHintTaskExpansionStrategy
implements TaskExpansionStrategy {
    private final AppRegistry appRegistry;
    private final ApplicationConfigurationMetadataResolver metadataResolver;
    @Autowired
    private ValueHintProvider[] valueHintProviders = new ValueHintProvider[0];

    ConfigurationPropertyValueHintTaskExpansionStrategy(AppRegistry appRegistry, ApplicationConfigurationMetadataResolver metadataResolver) {
        this.appRegistry = appRegistry;
        this.metadataResolver = metadataResolver;
    }

    @Override
    public boolean addProposals(String text, TaskDefinition parseResult, int detailLevel, List<CompletionProposal> collector) {
        HashSet propertyNames = new HashSet(parseResult.getProperties().keySet());
        propertyNames.removeAll(CompletionUtils.IMPLICIT_TASK_PARAMETER_NAMES);
        if (text.endsWith(" ") || propertyNames.isEmpty()) {
            return false;
        }
        String propertyName = this.recoverPropertyName(text);
        String alreadyTyped = (String)parseResult.getProperties().get(propertyName);
        String appName = parseResult.getRegisteredAppName();
        AppRegistration appRegistration = this.appRegistry.find(appName, ApplicationType.task);
        if (appRegistration == null) {
            return false;
        }
        Resource appResource = appRegistration.getResource();
        CompletionProposal.Factory proposals = CompletionProposal.expanding(text);
        List allProps = this.metadataResolver.listProperties(appResource, true);
        List whiteListedProps = this.metadataResolver.listProperties(appResource);
        URLClassLoader classLoader = null;
        try {
            for (ConfigurationMetadataProperty property : allProps) {
                if (!CompletionUtils.isMatchingProperty(propertyName, property, whiteListedProps)) continue;
                if (classLoader == null) {
                    classLoader = this.metadataResolver.createAppClassLoader(appResource);
                }
                for (ValueHintProvider valueHintProvider : this.valueHintProviders) {
                    List<ValueHint> valueHints = valueHintProvider.generateValueHints(property, classLoader);
                    if (!valueHints.isEmpty() && valueHintProvider.isExclusive(property)) {
                        collector.clear();
                    }
                    for (ValueHint valueHint : valueHints) {
                        String candidate = String.valueOf(valueHint.getValue());
                        if (candidate.equals(alreadyTyped) || !candidate.startsWith(alreadyTyped)) continue;
                        collector.add(proposals.withSuffix(candidate.substring(alreadyTyped.length()), valueHint.getShortDescription()));
                    }
                    if (valueHints.isEmpty() || !valueHintProvider.isExclusive(property)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (classLoader != null) {
                try {
                    classLoader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    private String recoverPropertyName(String text) {
        try {
            new TaskDefinition("__dummy", text + " --");
        }
        catch (CheckPointedParseException exception) {
            int end;
            List tokens = exception.getTokens();
            int tokenPointer = end = tokens.size() - 1 - 2;
            while (!((Token)tokens.get(tokenPointer - 1)).isKind(TokenKind.DOUBLE_MINUS)) {
                --tokenPointer;
            }
            StringBuilder builder = new StringBuilder();
            while (tokenPointer < end) {
                Token t = (Token)tokens.get(tokenPointer);
                if (t.isIdentifier()) {
                    builder.append(t.stringValue());
                } else {
                    builder.append(t.getKind().getTokenChars());
                }
                ++tokenPointer;
            }
            return builder.toString();
        }
        throw new AssertionError((Object)"Can't be reached");
    }
}

