/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.HashSet;
import java.util.List;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.CompletionUtils;
import org.springframework.cloud.dataflow.completion.StacktraceFingerprintingRecoveryStrategy;
import org.springframework.cloud.dataflow.configuration.metadata.ApplicationConfigurationMetadataResolver;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.StreamAppDefinition;
import org.springframework.cloud.dataflow.core.StreamDefinition;
import org.springframework.cloud.dataflow.core.dsl.CheckPointedParseException;
import org.springframework.cloud.dataflow.core.dsl.Token;
import org.springframework.cloud.dataflow.core.dsl.TokenKind;
import org.springframework.cloud.dataflow.registry.AppRegistration;
import org.springframework.cloud.dataflow.registry.AppRegistry;
import org.springframework.core.io.Resource;

public class UnfinishedConfigurationPropertyNameRecoveryStrategy
extends StacktraceFingerprintingRecoveryStrategy<CheckPointedParseException> {
    private final AppRegistry appRegistry;
    private final ApplicationConfigurationMetadataResolver metadataResolver;

    UnfinishedConfigurationPropertyNameRecoveryStrategy(AppRegistry appRegistry, ApplicationConfigurationMetadataResolver metadataResolver) {
        super(CheckPointedParseException.class, "file --foo", "file | bar --quick", "file --foo.", "file | bar --quick.");
        this.appRegistry = appRegistry;
        this.metadataResolver = metadataResolver;
    }

    @Override
    public void addProposals(String dsl, CheckPointedParseException exception, int detailLevel, List<CompletionProposal> collector) {
        ApplicationType appType;
        String safe = exception.getExpressionStringUntilCheckpoint();
        List tokens = exception.getTokens();
        int tokenPointer = tokens.size() - 1;
        while (!((Token)tokens.get(tokenPointer - 1)).isKind(TokenKind.DOUBLE_MINUS)) {
            --tokenPointer;
        }
        StringBuilder builder = null;
        builder = new StringBuilder();
        while (tokenPointer < tokens.size()) {
            Token t = (Token)tokens.get(tokenPointer);
            if (t.isIdentifier()) {
                builder.append(t.stringValue());
            } else {
                builder.append(t.getKind().getTokenChars());
            }
            ++tokenPointer;
        }
        String buffer = builder.toString();
        StreamDefinition streamDefinition = new StreamDefinition("__dummy", safe);
        StreamAppDefinition lastApp = (StreamAppDefinition)streamDefinition.getDeploymentOrderIterator().next();
        String lastAppName = lastApp.getName();
        AppRegistration lastAppRegistration = null;
        ApplicationType[] applicationTypeArray = CompletionUtils.determinePotentialTypes(lastApp);
        int n = applicationTypeArray.length;
        for (int i = 0; i < n && (lastAppRegistration = this.appRegistry.find(lastAppName, appType = applicationTypeArray[i])) == null; ++i) {
        }
        if (lastAppRegistration == null) {
            return;
        }
        HashSet alreadyPresentOptions = new HashSet(lastApp.getProperties().keySet());
        Resource jarFile = lastAppRegistration.getResource();
        CompletionProposal.Factory proposals = CompletionProposal.expanding(safe);
        for (ConfigurationMetadataProperty property : this.metadataResolver.listProperties(jarFile)) {
            String name = property.getName();
            if (alreadyPresentOptions.contains(name) || !name.startsWith(buffer)) continue;
            collector.add(proposals.withSeparateTokens("--" + name + "=", property.getShortDescription()));
        }
        if (detailLevel > 1) {
            for (ConfigurationMetadataProperty property : this.metadataResolver.listProperties(jarFile, true)) {
                String id = property.getId();
                if (alreadyPresentOptions.contains(id) || !id.startsWith(buffer)) continue;
                collector.add(proposals.withSeparateTokens("--" + id + "=", property.getShortDescription()));
            }
        }
    }
}

