/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.HashSet;
import java.util.List;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.StacktraceFingerprintingTaskRecoveryStrategy;
import org.springframework.cloud.dataflow.configuration.metadata.ApplicationConfigurationMetadataResolver;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.TaskDefinition;
import org.springframework.cloud.dataflow.core.dsl.CheckPointedParseException;
import org.springframework.cloud.dataflow.core.dsl.Token;
import org.springframework.cloud.dataflow.core.dsl.TokenKind;
import org.springframework.cloud.dataflow.registry.AppRegistration;
import org.springframework.cloud.dataflow.registry.AppRegistry;
import org.springframework.core.io.Resource;

public class UnfinishedConfigurationPropertyNameTaskRecoveryStrategy
extends StacktraceFingerprintingTaskRecoveryStrategy<CheckPointedParseException> {
    private final AppRegistry appRegistry;
    private final ApplicationConfigurationMetadataResolver metadataResolver;

    UnfinishedConfigurationPropertyNameTaskRecoveryStrategy(AppRegistry appRegistry, ApplicationConfigurationMetadataResolver metadataResolver) {
        super(CheckPointedParseException.class, "file --foo", "file --foo.");
        this.appRegistry = appRegistry;
        this.metadataResolver = metadataResolver;
    }

    @Override
    public void addProposals(String dsl, CheckPointedParseException exception, int detailLevel, List<CompletionProposal> collector) {
        String safe = exception.getExpressionStringUntilCheckpoint();
        List tokens = exception.getTokens();
        int tokenPointer = tokens.size() - 1;
        while (!((Token)tokens.get(tokenPointer - 1)).isKind(TokenKind.DOUBLE_MINUS)) {
            --tokenPointer;
        }
        StringBuilder builder = null;
        builder = new StringBuilder();
        while (tokenPointer < tokens.size()) {
            Token t = (Token)tokens.get(tokenPointer);
            if (t.isIdentifier()) {
                builder.append(t.stringValue());
            } else {
                builder.append(t.getKind().getTokenChars());
            }
            ++tokenPointer;
        }
        String buffer = builder.toString();
        TaskDefinition taskDefinition = new TaskDefinition("__dummy", safe);
        String lastAppName = taskDefinition.getRegisteredAppName();
        AppRegistration appRegistration = this.appRegistry.find(lastAppName, ApplicationType.task);
        if (appRegistration == null) {
            return;
        }
        HashSet alreadyPresentOptions = new HashSet(taskDefinition.getProperties().keySet());
        Resource jarFile = appRegistration.getResource();
        CompletionProposal.Factory proposals = CompletionProposal.expanding(safe);
        for (ConfigurationMetadataProperty property : this.metadataResolver.listProperties(jarFile)) {
            String name = property.getName();
            if (alreadyPresentOptions.contains(name) || !name.startsWith(buffer)) continue;
            collector.add(proposals.withSeparateTokens("--" + name + "=", property.getShortDescription()));
        }
        if (detailLevel > 1) {
            for (ConfigurationMetadataProperty property : this.metadataResolver.listProperties(jarFile, true)) {
                String id = property.getId();
                if (alreadyPresentOptions.contains(id) || !id.startsWith(buffer)) continue;
                collector.add(proposals.withSeparateTokens("--" + id + "=", property.getShortDescription()));
            }
        }
    }
}

