/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.cloud.dataflow.rest.job.TaskJobExecutionRel;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.util.Assert;

public class TaskExecutionResource
extends ResourceSupport {
    private long executionId;
    private int exitCode;
    private String taskName;
    private Date startTime;
    private Date endTime;
    private String exitMessage;
    private List<String> arguments;
    private List<Long> jobExecutionIds;
    private String errorMessage;
    private String externalExecutionId;

    public TaskExecutionResource() {
        this.arguments = new ArrayList<String>();
    }

    public TaskExecutionResource(TaskJobExecutionRel taskJobExecutionRel) {
        Assert.notNull((Object)taskJobExecutionRel, (String)"taskJobExecutionDTO must not be null");
        this.executionId = taskJobExecutionRel.getTaskExecution().getExecutionId();
        this.exitCode = taskJobExecutionRel.getTaskExecution().getExitCode();
        this.taskName = taskJobExecutionRel.getTaskExecution().getTaskName();
        this.exitMessage = taskJobExecutionRel.getTaskExecution().getExitMessage();
        this.arguments = Collections.unmodifiableList(taskJobExecutionRel.getTaskExecution().getArguments());
        this.startTime = taskJobExecutionRel.getTaskExecution().getStartTime();
        this.endTime = taskJobExecutionRel.getTaskExecution().getEndTime();
        this.errorMessage = taskJobExecutionRel.getTaskExecution().getErrorMessage();
        this.externalExecutionId = taskJobExecutionRel.getTaskExecution().getExternalExecutionId();
        this.jobExecutionIds = taskJobExecutionRel.getJobExecutionIds() == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Long>(taskJobExecutionRel.getJobExecutionIds()));
    }

    public long getExecutionId() {
        return this.executionId;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getExitMessage() {
        return this.exitMessage;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public List<Long> getJobExecutionIds() {
        return this.jobExecutionIds;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getExternalExecutionId() {
        return this.externalExecutionId;
    }

    public static class Page
    extends PagedResources<TaskExecutionResource> {
    }
}

