/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.cloud.dataflow.core.DefinitionUtils;
import org.springframework.cloud.dataflow.core.StreamAppDefinition;
import org.springframework.cloud.dataflow.core.StreamDefinition;
import org.springframework.cloud.dataflow.core.StreamDefinitionToDslConverter;
import org.springframework.cloud.dataflow.core.TaskDefinition;
import org.springframework.cloud.dataflow.core.TaskDefinitionToDslConverter;
import org.springframework.cloud.dataflow.core.dsl.TaskParser;
import org.springframework.cloud.dataflow.core.dsl.graph.Graph;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ArgumentSanitizer {
    private static final String[] REGEX_PARTS = new String[]{"*", "$", "^", "+"};
    private static final String REDACTION_STRING = "******";
    private static final String[] KEYS_TO_SANITIZE = new String[]{"username", "password", "secret", "key", "token", ".*credentials.*", "vcap_services", "url"};
    private Pattern[] keysToSanitize;
    private final StreamDefinitionToDslConverter streamDslConverter = new StreamDefinitionToDslConverter();
    private final TaskDefinitionToDslConverter taskDslConverter = new TaskDefinitionToDslConverter();

    public ArgumentSanitizer() {
        this.keysToSanitize = new Pattern[KEYS_TO_SANITIZE.length];
        for (int i = 0; i < this.keysToSanitize.length; ++i) {
            this.keysToSanitize[i] = this.getPattern(KEYS_TO_SANITIZE[i]);
        }
    }

    private Pattern getPattern(String value) {
        if (this.isRegex(value)) {
            return Pattern.compile(value, 2);
        }
        return Pattern.compile(".*" + value + "$", 2);
    }

    private boolean isRegex(String value) {
        for (String part : REGEX_PARTS) {
            if (!value.contains(part)) continue;
            return true;
        }
        return false;
    }

    public String sanitize(String argument) {
        int indexOfFirstEqual = argument.indexOf("=");
        if (indexOfFirstEqual == -1) {
            return argument;
        }
        String key = argument.substring(0, indexOfFirstEqual);
        String value = argument.substring(indexOfFirstEqual + 1);
        value = this.sanitize(key, value);
        return String.format("%s=%s", key, value);
    }

    public String sanitize(String key, String value) {
        if (StringUtils.hasText((String)value)) {
            for (Pattern pattern : this.keysToSanitize) {
                if (!pattern.matcher(key).matches()) continue;
                value = REDACTION_STRING;
                break;
            }
        }
        return value;
    }

    public JobParameters sanitizeJobParameters(JobParameters jobParameters) {
        HashMap newJobParameters = new HashMap();
        jobParameters.getParameters().forEach((key, jobParameter) -> {
            String updatedKey;
            String string = updatedKey = !jobParameter.isIdentifying() ? "-" + key : key;
            if (jobParameter.getType().equals((Object)JobParameter.ParameterType.STRING)) {
                newJobParameters.put(updatedKey, new JobParameter(this.sanitize((String)key, jobParameter.toString())));
            } else {
                newJobParameters.put(updatedKey, jobParameter);
            }
        });
        return new JobParameters(newJobParameters);
    }

    public String sanitizeStream(StreamDefinition streamDefinition) {
        List sanitizedAppDefinitions = streamDefinition.getAppDefinitions().stream().map(app -> StreamAppDefinition.Builder.from((StreamAppDefinition)app).setProperties(this.sanitizeProperties(app.getProperties())).build(streamDefinition.getName())).collect(Collectors.toList());
        return this.streamDslConverter.toDsl(sanitizedAppDefinitions);
    }

    public String sanitizeTaskDsl(TaskDefinition taskDefinition) {
        if (StringUtils.isEmpty((Object)taskDefinition.getDslText())) {
            return taskDefinition.getDslText();
        }
        TaskParser taskParser = new TaskParser(taskDefinition.getTaskName(), taskDefinition.getDslText(), true, true);
        Graph graph = taskParser.parse().toGraph();
        graph.getNodes().stream().forEach(node -> {
            if (node.properties != null) {
                node.properties.keySet().stream().forEach(key -> node.properties.put(key, DefinitionUtils.autoQuotes((String)this.sanitize((String)key, (String)node.properties.get(key)))));
            }
        });
        return graph.toDSLText();
    }

    public Map<String, String> sanitizeProperties(Map<String, String> properties) {
        if (!CollectionUtils.isEmpty(properties)) {
            LinkedHashMap<String, String> sanitizedProperties = new LinkedHashMap<String, String>(properties.size());
            for (Map.Entry<String, String> property : properties.entrySet()) {
                sanitizedProperties.put(property.getKey(), this.sanitize(property.getKey(), property.getValue()));
            }
            return sanitizedProperties;
        }
        return properties;
    }

    public List<String> sanitizeArguments(List<String> arguments) {
        if (!CollectionUtils.isEmpty(arguments)) {
            ArrayList<String> sanitizedArguments = new ArrayList<String>(arguments.size());
            for (String argument : arguments) {
                sanitizedArguments.add(this.sanitize(argument));
            }
            return sanitizedArguments;
        }
        return arguments;
    }
}

