/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.aws;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.SocketException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.function.adapter.aws.AWSLambdaUtils;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public final class CustomRuntimeEventLoop
implements SmartLifecycle {
    private static Log logger = LogFactory.getLog(CustomRuntimeEventLoop.class);
    static final String LAMBDA_VERSION_DATE = "2018-06-01";
    private static final String LAMBDA_ERROR_URL_TEMPLATE = "http://{0}/{1}/runtime/invocation/{2}/error";
    private static final String LAMBDA_RUNTIME_URL_TEMPLATE = "http://{0}/{1}/runtime/invocation/next";
    private static final String LAMBDA_INVOCATION_URL_TEMPLATE = "http://{0}/{1}/runtime/invocation/{2}/response";
    private static final String USER_AGENT_VALUE = String.format("spring-cloud-function/%s-%s", System.getProperty("java.runtime.version"), CustomRuntimeEventLoop.extractVersion());
    private final ConfigurableApplicationContext applicationContext;
    private volatile boolean running;
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    public CustomRuntimeEventLoop(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void run() {
        this.running = true;
        this.executor.execute(() -> this.eventLoop(this.applicationContext));
    }

    public void start() {
        this.run();
    }

    public void stop() {
        this.executor.shutdownNow();
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    private void eventLoop(ConfigurableApplicationContext context) {
        ConfigurableEnvironment environment = context.getEnvironment();
        logger.info((Object)"Starting spring-cloud-function CustomRuntimeEventLoop");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("AWS LAMBDA ENVIRONMENT: " + System.getenv()));
        }
        String runtimeApi = environment.getProperty("AWS_LAMBDA_RUNTIME_API");
        String eventUri = MessageFormat.format(LAMBDA_RUNTIME_URL_TEMPLATE, runtimeApi, LAMBDA_VERSION_DATE);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Event URI: " + eventUri));
        }
        RequestEntity requestEntity = RequestEntity.get((URI)URI.create(eventUri)).header("User-Agent", new String[]{USER_AGENT_VALUE}).build();
        FunctionCatalog functionCatalog = (FunctionCatalog)context.getBean(FunctionCatalog.class);
        RestTemplate rest = new RestTemplate();
        JsonMapper mapper = (JsonMapper)context.getBean(JsonMapper.class);
        logger.info((Object)"Entering event loop");
        while (this.isRunning()) {
            logger.debug((Object)"Attempting to get new event");
            ResponseEntity<String> response = this.pollForData(rest, (RequestEntity<Void>)requestEntity);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("New Event received: " + response));
            }
            if (response == null) continue;
            String requestId = response.getHeaders().getFirst("Lambda-Runtime-Aws-Request-Id");
            try {
                Message responseMessage;
                SimpleFunctionRegistry.FunctionInvocationWrapper function = this.locateFunction((Environment)environment, functionCatalog, response.getHeaders());
                Message<byte[]> eventMessage = AWSLambdaUtils.generateMessage(((String)response.getBody()).getBytes(StandardCharsets.UTF_8), function.getInputType(), function.isSupplier(), mapper);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Event message: " + eventMessage));
                }
                String invocationUrl = MessageFormat.format(LAMBDA_INVOCATION_URL_TEMPLATE, runtimeApi, LAMBDA_VERSION_DATE, requestId);
                String traceId = response.getHeaders().getFirst("Lambda-Runtime-Trace-Id");
                if (StringUtils.hasText((String)traceId)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Lambda-Runtime-Trace-Id: " + traceId));
                    }
                    System.setProperty("com.amazonaws.xray.traceHeader", traceId);
                }
                if ((responseMessage = (Message)function.apply(eventMessage)) != null && logger.isDebugEnabled()) {
                    logger.debug((Object)("Reply from function: " + responseMessage));
                }
                byte[] outputBody = AWSLambdaUtils.generateOutput(eventMessage, responseMessage, mapper, function.getOutputType());
                ResponseEntity result = rest.exchange(((RequestEntity.BodyBuilder)RequestEntity.post((URI)URI.create(invocationUrl)).header("User-Agent", new String[]{USER_AGENT_VALUE})).body((Object)outputBody), Object.class);
                if (!logger.isInfoEnabled()) continue;
                logger.info((Object)("Result POST status: " + result.getStatusCode()));
            }
            catch (Exception e) {
                this.propagateAwsError(requestId, e, mapper, runtimeApi, rest);
            }
        }
    }

    private void propagateAwsError(String requestId, Exception e, JsonMapper mapper, String runtimeApi, RestTemplate rest) {
        String errorMessage = e.getMessage();
        String errorType = e.getClass().getSimpleName();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        String stackTrace = sw.toString();
        HashMap<String, String> em = new HashMap<String, String>();
        em.put("errorMessage", errorMessage);
        em.put("errorType", errorType);
        em.put("stackTrace", stackTrace);
        byte[] outputBody = mapper.toJson(em);
        try {
            String errorUrl = MessageFormat.format(LAMBDA_ERROR_URL_TEMPLATE, runtimeApi, LAMBDA_VERSION_DATE, requestId);
            ResponseEntity result = rest.exchange(((RequestEntity.BodyBuilder)RequestEntity.post((URI)URI.create(errorUrl)).header("User-Agent", new String[]{USER_AGENT_VALUE})).body((Object)outputBody), Object.class);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Result ERROR status: " + result.getStatusCode()));
            }
        }
        catch (Exception e2) {
            throw new IllegalArgumentException("Failed to report error", e2);
        }
    }

    private ResponseEntity<String> pollForData(RestTemplate rest, RequestEntity<Void> requestEntity) {
        try {
            return rest.exchange(requestEntity, String.class);
        }
        catch (Exception e) {
            if (e instanceof SocketException) {
                this.stop();
            }
            return null;
        }
    }

    private SimpleFunctionRegistry.FunctionInvocationWrapper locateFunction(Environment environment, FunctionCatalog functionCatalog, HttpHeaders httpHeaders) {
        SimpleFunctionRegistry.FunctionInvocationWrapper function;
        MediaType contentType = httpHeaders.getContentType();
        String handlerName = environment.getProperty("DEFAULT_HANDLER");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Value of DEFAULT_HANDLER env: " + handlerName));
        }
        if ((function = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup(handlerName, new String[]{contentType.toString()})) == null) {
            logger.debug((Object)"Could not locate function under DEFAULT_HANDLER");
            handlerName = environment.getProperty("_HANDLER");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Value of _HANDLER env: " + handlerName));
            }
            function = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup(handlerName, new String[]{contentType.toString()});
        }
        if (function == null) {
            logger.debug((Object)"Could not locate function under _HANDLER");
            function = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup((String)null, new String[]{contentType.toString()});
        }
        if (function == null) {
            logger.info((Object)"Could not determine default function");
            handlerName = environment.getProperty("spring.cloud.function.definition");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Value of 'spring.cloud.function.definition' env: " + handlerName));
            }
            function = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup(handlerName, new String[]{contentType.toString()});
        }
        if (function == null) {
            logger.info((Object)"Could not determine DEFAULT_HANDLER, _HANDLER or 'spring.cloud.function.definition'");
            handlerName = httpHeaders.getFirst("spring.cloud.function.definition");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Value of 'spring.cloud.function.definition' header: " + handlerName));
            }
            function = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup(handlerName, new String[]{contentType.toString()});
        }
        Assert.notNull((Object)function, (String)("Failed to locate function. Tried locating default function, function by 'DEFAULT_HANDLER', '_HANDLER' env variable as well as'spring.cloud.function.definition'. Functions available in catalog are: " + functionCatalog.getNames(null)));
        if (function != null && logger.isInfoEnabled()) {
            logger.info((Object)("Located function " + function.getFunctionDefinition()));
        }
        return function;
    }

    private static String extractVersion() {
        try {
            String path = CustomRuntimeEventLoop.class.getProtectionDomain().getCodeSource().getLocation().toString();
            int endIndex = path.lastIndexOf(46);
            if (endIndex < 0) {
                return "UNKNOWN-VERSION";
            }
            int startIndex = path.lastIndexOf("/") + 1;
            return path.substring(startIndex, endIndex).replace("spring-cloud-function-adapter-aws-", "");
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to detect version", (Throwable)e);
            }
            return "UNKNOWN-VERSION";
        }
    }
}

