/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.aws;

import com.amazonaws.services.lambda.runtime.Context;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.http.HttpStatus;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.StreamUtils;
import reactor.core.publisher.Flux;

public final class AWSLambdaUtils {
    private static Log logger = LogFactory.getLog(AWSLambdaUtils.class);
    static final String AWS_API_GATEWAY = "aws-api-gateway";
    static final String AWS_EVENT = "aws-event";
    static final String IS_BASE64_ENCODED = "isBase64Encoded";
    static final String STATUS_CODE = "statusCode";
    static final String BODY = "body";
    static final String HEADERS = "headers";
    public static final String AWS_CONTEXT = "aws-context";

    private AWSLambdaUtils() {
    }

    static boolean isSupportedAWSType(Type inputType) {
        if (FunctionTypeUtils.isMessage((Type)inputType) || FunctionTypeUtils.isPublisher((Type)inputType)) {
            inputType = FunctionTypeUtils.getImmediateGenericType((Type)inputType, (int)0);
        }
        return FunctionTypeUtils.getRawType((Type)inputType).getPackage() != null && FunctionTypeUtils.getRawType((Type)inputType).getPackage().getName().startsWith("com.amazonaws.services.lambda.runtime.events");
    }

    public static Message generateMessage(InputStream payload, Type inputType, boolean isSupplier, JsonMapper jsonMapper, Context context) throws IOException {
        if (inputType != null && FunctionTypeUtils.isMessage((Type)inputType)) {
            inputType = FunctionTypeUtils.getImmediateGenericType((Type)inputType, (int)0);
        }
        if (inputType != null && InputStream.class.isAssignableFrom(FunctionTypeUtils.getRawType((Type)inputType))) {
            MessageBuilder msgBuilder = MessageBuilder.withPayload((Object)payload);
            if (context != null) {
                msgBuilder.setHeader(AWS_CONTEXT, (Object)context);
            }
            return msgBuilder.build();
        }
        return AWSLambdaUtils.generateMessage(StreamUtils.copyToByteArray((InputStream)payload), inputType, isSupplier, jsonMapper, context);
    }

    public static Message<byte[]> generateMessage(byte[] payload, Type inputType, boolean isSupplier, JsonMapper jsonMapper) {
        return AWSLambdaUtils.generateMessage(payload, inputType, isSupplier, jsonMapper, null);
    }

    public static Message<byte[]> generateMessage(byte[] payload, Type inputType, boolean isSupplier, JsonMapper jsonMapper, Context context) {
        Map msg;
        Object structMessage;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Received: " + new String(payload, StandardCharsets.UTF_8)));
        }
        boolean isApiGateway = (structMessage = jsonMapper.fromJson((Object)payload, Object.class)) instanceof Map && (((Map)structMessage).containsKey("httpMethod") || ((Map)structMessage).containsKey("routeKey") && ((Map)structMessage).containsKey("version"));
        MessageBuilder builder = MessageBuilder.withPayload((Object)(structMessage instanceof Map && (msg = (Map)structMessage).containsKey("payload") ? ((String)msg.get("payload")).getBytes(StandardCharsets.UTF_8) : payload));
        if (isApiGateway) {
            builder.setHeader(AWS_API_GATEWAY, (Object)true);
            if (JsonMapper.isJsonStringRepresentsCollection(((Map)structMessage).get(BODY))) {
                builder.setHeader("payload", ((Map)structMessage).get(BODY));
            }
        }
        if (!isSupplier && AWSLambdaUtils.isSupportedAWSType(inputType)) {
            builder.setHeader(AWS_EVENT, (Object)true);
        }
        if (context != null) {
            builder.setHeader(AWS_CONTEXT, (Object)context);
        }
        if (structMessage instanceof Map && ((Map)structMessage).containsKey(HEADERS)) {
            builder.copyHeaders((Map)((Map)structMessage).get(HEADERS));
        }
        Message requestMessage = builder.build();
        return requestMessage;
    }

    private static byte[] extractPayload(Message<Object> msg, JsonMapper objectMapper) {
        if (msg.getPayload() instanceof byte[]) {
            return (byte[])msg.getPayload();
        }
        return objectMapper.toJson(msg.getPayload());
    }

    private static Object convertFromJsonIfNecessary(Object value, JsonMapper objectMapper) {
        if (JsonMapper.isJsonString((Object)value)) {
            return objectMapper.fromJson(value, Object.class);
        }
        return value;
    }

    public static byte[] generateOutputFromObject(Message<?> requestMessage, Object output, JsonMapper objectMapper, Type functionOutputType) {
        Message responseMessage = null;
        if (output instanceof Publisher) {
            ArrayList<Object> result = new ArrayList<Object>();
            Message lastMessage = null;
            for (Object item : Flux.from((Publisher)((Publisher)output)).toIterable()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Response value: " + item));
                }
                if (item instanceof Message) {
                    Message message = (Message)item;
                    result.add(AWSLambdaUtils.convertFromJsonIfNecessary(message.getPayload(), objectMapper));
                    lastMessage = message;
                    continue;
                }
                result.add(AWSLambdaUtils.convertFromJsonIfNecessary(item, objectMapper));
            }
            Object resultPayload = result.size() == 1 ? objectMapper.toJson(result.get(0)) : (Object)(result.size() > 1 ? objectMapper.toJson(result) : null);
            if (resultPayload != null) {
                MessageBuilder messageBuilder = MessageBuilder.withPayload((Object)resultPayload);
                if (lastMessage != null) {
                    messageBuilder.copyHeaders((Map)lastMessage.getHeaders());
                }
                responseMessage = messageBuilder.build();
            }
        } else {
            responseMessage = (Message)output;
        }
        return AWSLambdaUtils.generateOutput(requestMessage, responseMessage, objectMapper, functionOutputType);
    }

    public static byte[] generateOutput(Message requestMessage, Message<?> responseMessage, JsonMapper objectMapper, Type functionOutputType) {
        byte[] responseBytes;
        String outputClassName;
        Class outputClass = FunctionTypeUtils.getRawType((Type)functionOutputType);
        if (outputClass != null && (outputClassName = outputClass.getName()).startsWith("com.amazonaws.services.lambda.runtime.events.")) {
            return AWSLambdaUtils.extractPayload(responseMessage, objectMapper);
        }
        byte[] byArray = responseBytes = responseMessage == null ? "\"OK\"".getBytes() : AWSLambdaUtils.extractPayload(responseMessage, objectMapper);
        if (requestMessage.getHeaders().containsKey((Object)AWS_API_GATEWAY) && ((Boolean)requestMessage.getHeaders().get((Object)AWS_API_GATEWAY)).booleanValue()) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put(IS_BASE64_ENCODED, responseMessage != null && responseMessage.getHeaders().containsKey((Object)IS_BASE64_ENCODED) ? responseMessage.getHeaders().get((Object)IS_BASE64_ENCODED) : Boolean.valueOf(false));
            AtomicReference<MessageHeaders> headers = new AtomicReference<MessageHeaders>();
            int statusCode = HttpStatus.OK.value();
            if (responseMessage != null) {
                headers.set(responseMessage.getHeaders());
                statusCode = ((MessageHeaders)headers.get()).containsKey((Object)STATUS_CODE) ? ((Integer)((MessageHeaders)headers.get()).get((Object)STATUS_CODE)).intValue() : HttpStatus.OK.value();
            }
            response.put(STATUS_CODE, statusCode);
            if (AWSLambdaUtils.isRequestKinesis((Message<Object>)requestMessage)) {
                HttpStatus httpStatus = HttpStatus.valueOf((int)statusCode);
                response.put("statusDescription", httpStatus.toString());
            }
            String body = responseMessage == null ? "\"OK\"" : new String(AWSLambdaUtils.extractPayload(responseMessage, objectMapper), StandardCharsets.UTF_8);
            response.put(BODY, body);
            if (responseMessage != null) {
                HashMap responseHeaders = new HashMap();
                ((MessageHeaders)headers.get()).keySet().forEach(key -> responseHeaders.put(key, ((MessageHeaders)headers.get()).get(key).toString()));
                response.put(HEADERS, responseHeaders);
            }
            try {
                responseBytes = objectMapper.toJson(response);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to serialize AWS Lambda output", e);
            }
        }
        return responseBytes;
    }

    private static boolean isRequestKinesis(Message<Object> requestMessage) {
        return requestMessage.getHeaders().containsKey((Object)"Records");
    }
}

