/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.azure;

import com.microsoft.azure.serverless.functions.ExecutionContext;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.jar.Manifest;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.ClassUtils;

public class AzureSpringFunctionInitializer
implements Closeable {
    private Function<Publisher<?>, Publisher<?>> function;
    private AtomicBoolean initialized = new AtomicBoolean();
    private Class<?> configurationClass;
    @Autowired(required=false)
    private FunctionCatalog catalog;
    private static ConfigurableApplicationContext context;

    public AzureSpringFunctionInitializer(Class<?> configurationClass) {
        this.configurationClass = configurationClass;
    }

    public AzureSpringFunctionInitializer() {
        this(AzureSpringFunctionInitializer.getStartClass());
    }

    @Override
    public void close() throws IOException {
        if (context != null) {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void initialize(ExecutionContext ctxt) {
        ConfigurableApplicationContext context = AzureSpringFunctionInitializer.context;
        if (!this.initialized.compareAndSet(false, true)) {
            return;
        }
        if (ctxt != null) {
            ctxt.getLogger().info("Initializing function");
        }
        if (context == null) {
            Class<AzureSpringFunctionInitializer> clazz = AzureSpringFunctionInitializer.class;
            // MONITORENTER : org.springframework.cloud.function.adapter.azure.AzureSpringFunctionInitializer.class
            if (context == null) {
                SpringApplicationBuilder builder = new SpringApplicationBuilder(new Object[]{this.configurationClass});
                ClassUtils.overrideThreadContextClassLoader((ClassLoader)AzureSpringFunctionInitializer.class.getClassLoader());
                AzureSpringFunctionInitializer.context = context = builder.web(false).run(new String[0]);
            }
            // MONITOREXIT : clazz
        }
        context.getAutowireCapableBeanFactory().autowireBean((Object)this);
        String name = context.getEnvironment().getProperty("function.name");
        if (name == null) {
            name = "function";
        }
        if (this.catalog == null) {
            this.function = (Function)context.getBean(name, Function.class);
            return;
        }
        Set functionNames = this.catalog.getNames(Function.class);
        this.function = (Function)this.catalog.lookup(Function.class, (String)functionNames.iterator().next());
    }

    protected Publisher<?> apply(Publisher<?> input) {
        if (this.function != null) {
            return this.function.apply(input);
        }
        throw new IllegalStateException("No function defined");
    }

    private static Class<?> getStartClass() {
        ClassLoader classLoader = AzureSpringFunctionInitializer.class.getClassLoader();
        if (System.getenv("MAIN_CLASS") != null) {
            return ClassUtils.resolveClassName((String)System.getenv("MAIN_CLASS"), (ClassLoader)classLoader);
        }
        try {
            Class<?> result = AzureSpringFunctionInitializer.getStartClass(Collections.list(classLoader.getResources("META-INF/MANIFEST.MF")));
            if (result == null) {
                result = AzureSpringFunctionInitializer.getStartClass(Collections.list(classLoader.getResources("meta-inf/manifest.mf")));
            }
            return result;
        }
        catch (Exception ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Class<?> getStartClass(List<URL> list) {
        Iterator<URL> iterator = list.iterator();
        while (iterator.hasNext()) {
            URL url = iterator.next();
            try (InputStream inputStream = url.openStream();){
                Class aClass;
                SpringBootApplication declaredAnnotation;
                Manifest manifest = new Manifest(inputStream);
                String startClass = manifest.getMainAttributes().getValue("Main-Class");
                if (startClass == null || (declaredAnnotation = (aClass = ClassUtils.forName((String)startClass, (ClassLoader)AzureSpringFunctionInitializer.class.getClassLoader())).getDeclaredAnnotation(SpringBootApplication.class)) == null) continue;
                Class clazz = aClass;
                return clazz;
            }
            catch (Exception exception) {}
        }
        return null;
    }
}

