/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.catalog;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.core.FluxConsumer;
import org.springframework.cloud.function.core.FluxFunction;
import org.springframework.cloud.function.core.FluxToMonoFunction;
import org.springframework.cloud.function.core.MonoToFluxFunction;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MessageFunction
implements Function<Publisher<Message<?>>, Publisher<Message<?>>> {
    private final Function<?, ?> delegate;

    public MessageFunction(Function<?, ?> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Publisher<Message<?>> apply(Publisher<Message<?>> input) {
        Flux flux = Flux.from(input);
        if (this.delegate instanceof FluxFunction) {
            Function target = (Function)((FluxFunction)this.delegate).getTarget();
            return flux.map(value -> MessageBuilder.withPayload(target.apply(value.getPayload())).copyHeaders((Map)value.getHeaders()).build());
        }
        if (this.delegate instanceof MonoToFluxFunction) {
            Function target = (Function)((MonoToFluxFunction)this.delegate).getTarget();
            return flux.next().flatMapMany(value -> ((Flux)target.apply(Mono.just((Object)value.getPayload()))).map(object -> MessageBuilder.withPayload((Object)object).copyHeaders((Map)value.getHeaders()).build()));
        }
        if (this.delegate instanceof FluxToMonoFunction) {
            Function target = (Function)((FluxToMonoFunction)this.delegate).getTarget();
            AtomicReference headers = new AtomicReference();
            return ((Mono)target.apply(flux.map(messsage -> {
                headers.set(messsage.getHeaders());
                return messsage.getPayload();
            }))).map(payload -> MessageBuilder.withPayload((Object)payload).copyHeaders((Map)headers.get()).build());
        }
        if (this.delegate instanceof FluxConsumer) {
            FluxConsumer target = (FluxConsumer)this.delegate;
            AtomicReference headers = new AtomicReference();
            Mono mapped = target.apply(flux.map(messsage -> {
                headers.set(messsage.getHeaders());
                return messsage.getPayload();
            }));
            return mapped.map(value -> MessageBuilder.createMessage(null, (MessageHeaders)((MessageHeaders)headers.get())));
        }
        Function<?, ?> function = this.delegate;
        return flux.map(value -> MessageBuilder.withPayload(function.apply(value.getPayload())).copyHeaders((Map)value.getHeaders()).build());
    }
}

