/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.config;

import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.function.core.WrappedFunction;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SignalType;

public class RoutingFunction
implements Function<Publisher<Message<?>>, Publisher<?>> {
    public static final String FUNCTION_NAME = "router";
    private final FunctionCatalog functionCatalog;
    private final FunctionInspector functionInspector;
    private final MessageConverter messageConverter;

    RoutingFunction(FunctionCatalog functionCatalog, FunctionInspector functionInspector, MessageConverter messageConverter) {
        this.functionCatalog = functionCatalog;
        this.functionInspector = functionInspector;
        this.messageConverter = messageConverter;
    }

    @Override
    public Publisher<?> apply(Publisher<Message<?>> input) {
        return Flux.from(input).switchOnFirst((signal, flux) -> {
            Assert.isTrue((signal.hasValue() && signal.getType() == SignalType.ON_NEXT ? 1 : 0) != 0, (String)("Signal has no value or wrong type " + signal));
            WrappedFunction function = this.getRouteToFunction((Message)signal.get());
            return flux.map(arg_0 -> this.lambda$null$0((Function)function, arg_0)).transform((Function)function);
        });
    }

    private WrappedFunction getRouteToFunction(Message<?> message) {
        String routeToFunctionName = (String)message.getHeaders().get((Object)"function.name");
        WrappedFunction function = (WrappedFunction)this.functionCatalog.lookup(routeToFunctionName);
        Assert.notNull((Object)function, (String)("Failed to locate function specified with 'function.name':" + message.getHeaders().get((Object)"function.name")));
        return function;
    }

    private Object convertInput(Message<?> message, Object function) {
        Class<?> inputType = this.functionInspector.getInputType(function);
        Object inputValue = message.getPayload();
        if (!inputValue.getClass().isAssignableFrom(inputType)) {
            inputValue = this.messageConverter.fromMessage(message, this.functionInspector.getInputType(function));
        }
        if (this.functionInspector.isMessage(function)) {
            inputValue = MessageBuilder.createMessage((Object)inputValue, (MessageHeaders)message.getHeaders());
        }
        Assert.notNull((Object)inputValue, (String)("Failed to determine input value of type " + inputType + " from Message '" + message + "'. No suitable Message Converter found."));
        return inputValue;
    }

    private /* synthetic */ Object lambda$null$0(Function function, Message message) {
        Object inputValue = this.convertInput(message, function);
        return inputValue;
    }
}

