/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.config;

import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.util.MimeType;

public class JsonMessageConverter
extends AbstractMessageConverter {
    private final JsonMapper jsonMapper;

    public JsonMessageConverter(JsonMapper jsonMapper) {
        this(jsonMapper, new MimeType("application", "json"));
    }

    public JsonMessageConverter(JsonMapper jsonMapper, MimeType ... supportedMimeTypes) {
        super(supportedMimeTypes);
        this.jsonMapper = jsonMapper;
    }

    protected boolean supports(Class<?> clazz) {
        throw new UnsupportedOperationException();
    }

    protected boolean canConvertTo(Object payload, @Nullable MessageHeaders headers) {
        return this.supportsMimeType(headers);
    }

    protected boolean canConvertFrom(Message<?> message, @Nullable Class<?> targetClass) {
        return targetClass != null && this.supportsMimeType(message.getHeaders());
    }

    protected Object convertFromInternal(Message<?> message, Class<?> targetClass, @Nullable Object conversionHint) {
        if (targetClass.isInstance(message.getPayload())) {
            return message.getPayload();
        }
        Object result = this.jsonMapper.fromJson(message.getPayload(), targetClass);
        return result;
    }

    protected Object convertToInternal(Object payload, @Nullable MessageHeaders headers, @Nullable Object conversionHint) {
        return this.jsonMapper.toJson(payload);
    }
}

