/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.config;

import java.util.Map;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.MimeType;

public final class NegotiatingMessageConverterWrapper
implements SmartMessageConverter {
    public static final String ACCEPT = "accept";
    private final AbstractMessageConverter delegate;

    private NegotiatingMessageConverterWrapper(AbstractMessageConverter delegate) {
        this.delegate = delegate;
    }

    public static NegotiatingMessageConverterWrapper wrap(AbstractMessageConverter delegate) {
        return new NegotiatingMessageConverterWrapper(delegate);
    }

    public Object fromMessage(Message<?> message, Class<?> targetClass, Object conversionHint) {
        return this.delegate.fromMessage(message, targetClass, conversionHint);
    }

    public Message<?> toMessage(Object payload, MessageHeaders headers, Object conversionHint) {
        MimeType accepted = (MimeType)headers.get((Object)ACCEPT, MimeType.class);
        MessageHeaderAccessor accessor = new MessageHeaderAccessor();
        accessor.copyHeaders((Map)headers);
        accessor.removeHeader(ACCEPT);
        if (accepted == null) {
            accepted = (MimeType)headers.get((Object)"contentType", MimeType.class);
        }
        if (accepted != null) {
            for (MimeType supportedConcreteType : this.delegate.getSupportedMimeTypes()) {
                if (!accepted.includes(supportedConcreteType)) continue;
                accessor.setHeader("contentType", (Object)supportedConcreteType);
                Message result = this.delegate.toMessage(payload, accessor.toMessageHeaders(), conversionHint);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public Object fromMessage(Message<?> message, Class<?> targetClass) {
        return this.fromMessage(message, targetClass, null);
    }

    public Message<?> toMessage(Object payload, MessageHeaders headers) {
        return this.toMessage(payload, headers, null);
    }
}

