/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.flux.request;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.function.context.message.MessageUtils;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.cloud.function.web.flux.constants.WebRequestConstants;
import org.springframework.cloud.function.web.flux.request.FluxRequest;
import org.springframework.cloud.function.web.util.HeaderUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.Ordered;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.util.ContentCachingRequestWrapper;

public class FluxHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver,
Ordered {
    private static Log logger = LogFactory.getLog(FluxHandlerMethodArgumentResolver.class);
    private final JsonMapper mapper;
    private FunctionInspector inspector;

    public FluxHandlerMethodArgumentResolver(FunctionInspector inspector, JsonMapper mapper) {
        this.inspector = inspector;
        this.mapper = mapper;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        List<Object> body;
        Object handler = webRequest.getAttribute(WebRequestConstants.HANDLER, 0);
        Class<Object> type = this.inspector.getInputType(handler);
        if (type == null) {
            type = Object.class;
        }
        boolean message = this.inspector.isMessage(handler);
        ContentCachingRequestWrapper nativeRequest = new ContentCachingRequestWrapper((HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resolving request body into type: " + type));
        }
        if (this.isPlainText(webRequest) && CharSequence.class.isAssignableFrom(type)) {
            body = Arrays.asList(StreamUtils.copyToString((InputStream)nativeRequest.getInputStream(), (Charset)Charset.forName("UTF-8")));
            nativeRequest.setAttribute(WebRequestConstants.INPUT_SINGLE, (Object)true);
        } else {
            String json = new String(StreamUtils.copyToString((InputStream)nativeRequest.getInputStream(), (Charset)Charset.forName("UTF-8")));
            if (!StringUtils.hasText((String)json)) {
                body = null;
            } else if (json.startsWith("[")) {
                body = this.mapper.toList(json, type);
            } else {
                nativeRequest.setAttribute(WebRequestConstants.INPUT_SINGLE, (Object)true);
                body = Arrays.asList(this.mapper.toSingle(json, type));
            }
        }
        if (body != null && message) {
            ArrayList<Object> messages = new ArrayList<Object>();
            MessageHeaders headers = HeaderUtils.fromHttp(new ServletServerHttpRequest((HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class)).getHeaders());
            for (Object payload : body) {
                messages.add(MessageUtils.create((Object)handler, (Object)payload, (Map)headers));
            }
            body = messages;
        }
        return new FluxRequest<String>(body);
    }

    private boolean isPlainText(NativeWebRequest webRequest) {
        String value = webRequest.getHeader("Content-Type");
        if (value != null) {
            return MediaType.valueOf((String)value).isCompatibleWith(MediaType.TEXT_PLAIN);
        }
        return false;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return FluxRequest.class.isAssignableFrom(parameter.getParameterType());
    }
}

